"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AuditdGenericFileLine = exports.AuditdGenericFileDetails = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _draggables = require("../../../../../../common/components/draggables");
var i18n = _interopRequireWildcard(require("./translations"));
var _netflow = require("../netflow");
var _helpers = require("../helpers");
var _process_draggable = require("../process_draggable");
var _args = require("../args");
var _session_user_host_working_dir = require("./session_user_host_working_dir");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/timeline/body/renderers/auditd/generic_file_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AuditdGenericFileLine = exports.AuditdGenericFileLine = /*#__PURE__*/_react.default.memo(({
  id,
  contextId,
  hostName,
  userName,
  result,
  primary,
  secondary,
  filePath,
  processName,
  processPid,
  processExecutable,
  processTitle,
  workingDirectory,
  args,
  session,
  text,
  fileIcon,
  scopeId
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  justifyContent: "center",
  gutterSize: "none",
  wrap: true,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 65,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_session_user_host_working_dir.SessionUserHostWorkingDir, {
  eventId: id,
  scopeId: scopeId,
  contextId: contextId,
  hostName: hostName,
  userName: userName,
  primary: primary,
  secondary: secondary,
  workingDirectory: workingDirectory,
  session: session,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 66,
    columnNumber: 7
  }
}), (filePath != null || processExecutable != null) && /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
  grow: false,
  component: "span",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 78,
    columnNumber: 9
  }
}, text), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
  grow: false,
  component: "span",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 82,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
  scopeId: scopeId,
  contextId: contextId,
  eventId: id,
  field: "file.path",
  value: filePath,
  iconType: fileIcon,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 83,
    columnNumber: 9
  }
})), processExecutable != null && /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
  grow: false,
  component: "span",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 93,
    columnNumber: 9
  }
}, i18n.USING), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
  grow: false,
  component: "span",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 97,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_process_draggable.ProcessDraggable, {
  scopeId: scopeId,
  contextId: contextId,
  endgamePid: undefined,
  endgameProcessName: undefined,
  eventId: id,
  processPid: processPid,
  processName: processName,
  processExecutable: processExecutable,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 98,
    columnNumber: 9
  }
})), /*#__PURE__*/_react.default.createElement(_args.Args, {
  scopeId: scopeId,
  eventId: id,
  args: args,
  contextId: contextId,
  processTitle: processTitle,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 109,
    columnNumber: 7
  }
}), result != null && /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
  grow: false,
  component: "span",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 117,
    columnNumber: 9
  }
}, i18n.WITH_RESULT), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
  grow: false,
  component: "span",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 121,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
  scopeId: scopeId,
  contextId: contextId,
  eventId: id,
  field: "auditd.result",
  queryValue: result,
  value: result,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 122,
    columnNumber: 9
  }
}))));
AuditdGenericFileLine.displayName = 'AuditdGenericFileLine';
const AuditdGenericFileDetails = exports.AuditdGenericFileDetails = /*#__PURE__*/_react.default.memo(({
  data,
  contextId,
  text,
  fileIcon = 'document',
  timelineId
}) => {
  const id = data._id;
  const session = (0, _fp.get)('auditd.session[0]', data);
  const hostName = (0, _fp.get)('host.name[0]', data);
  const userName = (0, _fp.get)('user.name[0]', data);
  const result = (0, _fp.get)('auditd.result[0]', data);
  const processPid = (0, _fp.get)('process.pid[0]', data);
  const processName = (0, _fp.get)('process.name[0]', data);
  const processExecutable = (0, _fp.get)('process.executable[0]', data);
  const processTitle = (0, _fp.get)('process.title[0]', data);
  const workingDirectory = (0, _fp.get)('process.working_directory[0]', data);
  const filePath = (0, _fp.get)('file.path[0]', data);
  const primary = (0, _fp.get)('auditd.summary.actor.primary[0]', data);
  const secondary = (0, _fp.get)('auditd.summary.actor.secondary[0]', data);
  const args = (0, _fp.get)('process.args', data);
  if (data.process != null) {
    return /*#__PURE__*/_react.default.createElement(_helpers.Details, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(AuditdGenericFileLine, {
      id: id,
      scopeId: timelineId,
      contextId: contextId,
      text: text,
      hostName: hostName,
      userName: userName,
      filePath: filePath,
      processName: processName,
      processPid: processPid,
      processExecutable: processExecutable,
      processTitle: processTitle,
      workingDirectory: workingDirectory,
      args: args,
      session: session,
      primary: primary,
      secondary: secondary,
      fileIcon: fileIcon,
      result: result,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 11
      }
    }), /*#__PURE__*/_react.default.createElement(_netflow.NetflowRenderer, {
      data: data,
      timelineId: timelineId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 11
      }
    }));
  } else {
    return null;
  }
});
AuditdGenericFileDetails.displayName = 'AuditdGenericFileDetails';