"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderers = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _timeline = require("../../../../../common/api/timeline");
var _examples = require("../examples");
var _constants = require("./constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/timelines/components/row_renderers_browser/catalog/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Link = ({
  children,
  url
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  href: url,
  target: "_blank",
  rel: "noopener nofollow noreferrer",
  "data-test-subj": "externalLink",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 34,
    columnNumber: 3
  }
}, children);
const renderers = exports.renderers = [{
  id: _timeline.RowRendererIdEnum.alerts,
  name: _constants.eventRendererNames[_timeline.RowRendererIdEnum.alerts],
  description: i18n.ALERTS_DESCRIPTION,
  example: _examples.AlertsExample,
  searchableDescription: i18n.ALERTS_DESCRIPTION
}, {
  id: _timeline.RowRendererIdEnum.auditd,
  name: _constants.eventRendererNames[_timeline.RowRendererIdEnum.auditd],
  description: /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(Link, {
    url: "https://www.elastic.co/guide/en/beats/auditbeat/current/auditbeat-module-auditd.html",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  }, i18n.AUDITD_NAME), ' ', i18n.AUDITD_DESCRIPTION_PART1),
  example: _examples.AuditdExample,
  searchableDescription: `${i18n.AUDITD_NAME} ${i18n.AUDITD_DESCRIPTION_PART1}`
}, {
  id: _timeline.RowRendererIdEnum.auditd_file,
  name: _constants.eventRendererNames[_timeline.RowRendererIdEnum.auditd_file],
  description: /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(Link, {
    url: "https://www.elastic.co/guide/en/beats/auditbeat/current/auditbeat-module-auditd.html",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 9
    }
  }, i18n.AUDITD_NAME), ' ', i18n.AUDITD_FILE_DESCRIPTION_PART1),
  example: _examples.AuditdFileExample,
  searchableDescription: `${i18n.AUDITD_FILE_NAME} ${i18n.AUDITD_FILE_DESCRIPTION_PART1}`
}, {
  id: _timeline.RowRendererIdEnum.library,
  name: _constants.eventRendererNames[_timeline.RowRendererIdEnum.library],
  description: i18n.LIBRARY_DESCRIPTION,
  example: _examples.LibraryExample,
  searchableDescription: i18n.LIBRARY_DESCRIPTION
}, {
  id: _timeline.RowRendererIdEnum.system_security_event,
  name: _constants.eventRendererNames[_timeline.RowRendererIdEnum.system_security_event],
  description: /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }, i18n.AUTHENTICATION_DESCRIPTION_PART1), /*#__PURE__*/_react.default.createElement("br", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 9
    }
  }, i18n.AUTHENTICATION_DESCRIPTION_PART2)),
  example: _examples.SystemSecurityEventExample,
  searchableDescription: `${i18n.AUTHENTICATION_DESCRIPTION_PART1} ${i18n.AUTHENTICATION_DESCRIPTION_PART2}`
}, {
  id: _timeline.RowRendererIdEnum.system_dns,
  name: _constants.eventRendererNames[_timeline.RowRendererIdEnum.system_dns],
  description: i18n.DNS_DESCRIPTION_PART1,
  example: _examples.SystemDnsExample,
  searchableDescription: i18n.DNS_DESCRIPTION_PART1
}, {
  id: _timeline.RowRendererIdEnum.netflow,
  name: _constants.eventRendererNames[_timeline.RowRendererIdEnum.netflow],
  description: /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 9
    }
  }, i18n.FLOW_DESCRIPTION_PART1), /*#__PURE__*/_react.default.createElement("br", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 9
    }
  }, i18n.FLOW_DESCRIPTION_PART2)),
  example: _examples.NetflowExample,
  searchableDescription: `${i18n.FLOW_DESCRIPTION_PART1} ${i18n.FLOW_DESCRIPTION_PART2}`
}, {
  id: _timeline.RowRendererIdEnum.system,
  name: _constants.eventRendererNames[_timeline.RowRendererIdEnum.system],
  description: /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 9
    }
  }, i18n.SYSTEM_DESCRIPTION_PART1, ' ', /*#__PURE__*/_react.default.createElement(Link, {
    url: "https://www.elastic.co/guide/en/beats/auditbeat/current/auditbeat-module-system.html",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 11
    }
  }, i18n.SYSTEM_NAME), ' ', i18n.SYSTEM_DESCRIPTION_PART2), /*#__PURE__*/_react.default.createElement("br", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 9
    }
  }, i18n.SYSTEM_DESCRIPTION_PART3)),
  example: _examples.SystemExample,
  searchableDescription: `${i18n.SYSTEM_DESCRIPTION_PART1} ${i18n.SYSTEM_NAME} ${i18n.SYSTEM_DESCRIPTION_PART2} ${i18n.SYSTEM_DESCRIPTION_PART3}`
}, {
  id: _timeline.RowRendererIdEnum.system_endgame_process,
  name: _constants.eventRendererNames[_timeline.RowRendererIdEnum.system_endgame_process],
  description: /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 9
    }
  }, i18n.PROCESS_DESCRIPTION_PART1), /*#__PURE__*/_react.default.createElement("br", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 9
    }
  }, i18n.PROCESS_DESCRIPTION_PART2)),
  example: _examples.SystemEndgameProcessExample,
  searchableDescription: `${i18n.PROCESS_DESCRIPTION_PART1} ${i18n.PROCESS_DESCRIPTION_PART2}`
}, {
  id: _timeline.RowRendererIdEnum.registry,
  name: _constants.eventRendererNames[_timeline.RowRendererIdEnum.registry],
  description: i18n.REGISTRY_DESCRIPTION,
  example: _examples.RegistryExample,
  searchableDescription: i18n.REGISTRY_DESCRIPTION
}, {
  id: _timeline.RowRendererIdEnum.system_fim,
  name: _constants.eventRendererNames[_timeline.RowRendererIdEnum.system_fim],
  description: i18n.FIM_DESCRIPTION_PART1,
  example: _examples.SystemFimExample,
  searchableDescription: i18n.FIM_DESCRIPTION_PART1
}, {
  id: _timeline.RowRendererIdEnum.system_file,
  name: _constants.eventRendererNames[_timeline.RowRendererIdEnum.system_file],
  description: i18n.FILE_DESCRIPTION_PART1,
  example: _examples.SystemFileExample,
  searchableDescription: i18n.FILE_DESCRIPTION_PART1
}, {
  id: _timeline.RowRendererIdEnum.system_socket,
  name: _constants.eventRendererNames[_timeline.RowRendererIdEnum.system_socket],
  description: /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 9
    }
  }, i18n.SOCKET_DESCRIPTION_PART1), /*#__PURE__*/_react.default.createElement("br", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 9
    }
  }, i18n.SOCKET_DESCRIPTION_PART2)),
  example: _examples.SystemSocketExample,
  searchableDescription: `${i18n.SOCKET_DESCRIPTION_PART1} ${i18n.SOCKET_DESCRIPTION_PART2}`
}, {
  id: _timeline.RowRendererIdEnum.suricata,
  name: _constants.eventRendererNames[_timeline.RowRendererIdEnum.suricata],
  description: /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 7
    }
  }, i18n.SURICATA_DESCRIPTION_PART1, ' ', /*#__PURE__*/_react.default.createElement(Link, {
    url: "https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-module-suricata.html",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 9
    }
  }, i18n.SURICATA_NAME), ' ', i18n.SURICATA_DESCRIPTION_PART2),
  example: _examples.SuricataExample,
  searchableDescription: `${i18n.SURICATA_DESCRIPTION_PART1} ${i18n.SURICATA_NAME} ${i18n.SURICATA_DESCRIPTION_PART2}`
}, {
  id: _timeline.RowRendererIdEnum.threat_match,
  name: _constants.eventRendererNames[_timeline.RowRendererIdEnum.threat_match],
  description: i18n.THREAT_MATCH_DESCRIPTION,
  example: _examples.ThreatMatchExample,
  searchableDescription: `${i18n.THREAT_MATCH_NAME} ${i18n.THREAT_MATCH_DESCRIPTION}`
}, {
  id: _timeline.RowRendererIdEnum.zeek,
  name: _constants.eventRendererNames[_timeline.RowRendererIdEnum.zeek],
  description: /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 7
    }
  }, i18n.ZEEK_DESCRIPTION_PART1, ' ', /*#__PURE__*/_react.default.createElement(Link, {
    url: "https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-module-zeek.html",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 9
    }
  }, i18n.ZEEK_NAME), ' ', i18n.ZEEK_DESCRIPTION_PART2),
  example: _examples.ZeekExample,
  searchableDescription: `${i18n.ZEEK_DESCRIPTION_PART1} ${i18n.ZEEK_NAME} ${i18n.ZEEK_DESCRIPTION_PART2}`
}];