"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddToTimelineContextMenu = exports.AddToTimelineCellAction = exports.AddToTimelineButtonIcon = exports.AddToTimelineButtonEmpty = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _timeline_capabilities = require("../../../../common/utils/timeline_capabilities");
var _data_provider = require("../utils/data_provider");
var _field_value = require("../../indicators/utils/field_value");
var _kibana = require("../../../../common/lib/kibana");
var _styles = require("./styles");
var _use_add_to_timeline = require("../hooks/use_add_to_timeline");
var _translations = require("./translations");
var _use_add_to_timeline_button = require("../hooks/use_add_to_timeline_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/threat_intelligence/modules/timeline/components/add_to_timeline.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ICON_TYPE = 'timeline';
/**
 * Add to timeline feature, leverages the built-in functionality retrieves from the timeLineService (see ThreatIntelligenceSecuritySolutionContext in x-pack/plugins/threat_intelligence/public/types.ts)
 * Clicking on the button will add a key-value pair to an Untitled timeline.
 *
 * This component is renders an {@link EuiButtonIcon}.
 *
 * @returns add to timeline button or an empty component
 */
const AddToTimelineButtonIcon = ({
  data,
  field,
  'data-test-subj': dataTestSubj
}) => {
  const addToTimelineButton = (0, _use_add_to_timeline_button.useAddToTimelineButton)();
  const {
    application: {
      capabilities
    }
  } = (0, _kibana.useKibana)().services;
  const {
    read: hasAccessToTimeline
  } = (0, _timeline_capabilities.extractTimelineCapabilities)(capabilities);
  const {
    addToTimelineProps
  } = (0, _use_add_to_timeline.useAddToTimeline)({
    indicator: data,
    field
  });
  if (!hasAccessToTimeline || !addToTimelineProps) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, addToTimelineButton(addToTimelineProps)));
};

/**
 * Add to timeline feature, leverages the built-in functionality retrieves from the timeLineService (see ThreatIntelligenceSecuritySolutionContext in x-pack/plugins/threat_intelligence/public/types.ts)
 * Clicking on the button will add a key-value pair to an Untitled timeline.
 *
 * This component is renders an {@link EuiButtonEmpty}.
 *
 * @returns add to timeline button or an empty component
 */
exports.AddToTimelineButtonIcon = AddToTimelineButtonIcon;
const AddToTimelineButtonEmpty = ({
  data,
  field,
  'data-test-subj': dataTestSubj
}) => {
  const styles = (0, _styles.useStyles)();
  const {
    application: {
      capabilities
    }
  } = (0, _kibana.useKibana)().services;
  const {
    read: hasAccessToTimeline
  } = (0, _timeline_capabilities.extractTimelineCapabilities)(capabilities);
  const buttonRef = (0, _react.useRef)(null);
  const {
    analytics,
    i18n: i18nStart,
    theme
  } = (0, _kibana.useKibana)().services;
  const startServices = {
    analytics,
    i18n: i18nStart,
    theme
  };
  const addToTimelineButton = (0, _use_add_to_timeline_button.useAddToTimelineButton)();
  const {
    key,
    value
  } = typeof data === 'string' ? {
    key: field,
    value: data
  } : (0, _field_value.getIndicatorFieldAndValue)(data, field);
  if (!hasAccessToTimeline || !(0, _field_value.fieldAndValueValid)(key, value)) {
    return null;
  }
  const dataProvider = [(0, _data_provider.generateDataProvider)(key, value)];
  const addToTimelineProps = {
    dataProvider,
    field: key,
    ownFocus: false,
    startServices
  };

  // Use case is for the barchart legend (for example).
  // We can't use the addToTimelineButton directly because the UI doesn't work in a EuiContextMenu.
  // We hide it and use the defaultFocusedButtonRef props to programmatically click it.
  addToTimelineProps.defaultFocusedButtonRef = buttonRef;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.displayNone,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 7
    }
  }, addToTimelineButton(addToTimelineProps)), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _translations.TITLE,
    iconType: ICON_TYPE,
    iconSize: "s",
    color: "primary",
    onClick: () => {
      var _buttonRef$current;
      return (_buttonRef$current = buttonRef.current) === null || _buttonRef$current === void 0 ? void 0 : _buttonRef$current.click();
    },
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 9
    }
  }, _translations.TITLE)));
};

/**
 * Add to timeline feature, leverages the built-in functionality retrieves from the timeLineService (see ThreatIntelligenceSecuritySolutionContext in x-pack/plugins/threat_intelligence/public/types.ts)
 * Clicking on the button will add a key-value pair to an Untitled timeline.
 *
 * This component is to be used in an EuiContextMenu.
 *
 * @returns add to timeline {@link EuiContextMenuItem} for a context menu
 */
exports.AddToTimelineButtonEmpty = AddToTimelineButtonEmpty;
const AddToTimelineContextMenu = ({
  data,
  field,
  'data-test-subj': dataTestSubj
}) => {
  const styles = (0, _styles.useStyles)();
  const {
    application: {
      capabilities
    }
  } = (0, _kibana.useKibana)().services;
  const {
    read: hasAccessToTimeline
  } = (0, _timeline_capabilities.extractTimelineCapabilities)(capabilities);
  const contextMenuRef = (0, _react.useRef)(null);
  const {
    analytics,
    i18n: i18nStart,
    theme
  } = (0, _kibana.useKibana)().services;
  const startServices = {
    analytics,
    i18n: i18nStart,
    theme
  };
  const addToTimelineButton = (0, _use_add_to_timeline_button.useAddToTimelineButton)();
  const {
    key,
    value
  } = typeof data === 'string' ? {
    key: field,
    value: data
  } : (0, _field_value.getIndicatorFieldAndValue)(data, field);
  if (!hasAccessToTimeline || !(0, _field_value.fieldAndValueValid)(key, value)) {
    return null;
  }
  const dataProvider = [(0, _data_provider.generateDataProvider)(key, value)];
  const addToTimelineProps = {
    dataProvider,
    field: key,
    ownFocus: false,
    startServices
  };

  // Use case is for the barchart legend (for example).
  // We can't use the addToTimelineButton directly because the UI doesn't work in a EuiContextMenu.
  // We hide it and use the defaultFocusedButtonRef props to programmatically click it.
  addToTimelineProps.defaultFocusedButtonRef = contextMenuRef;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    css: styles.displayNone,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 7
    }
  }, addToTimelineButton(addToTimelineProps)), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "addToTimeline",
    icon: ICON_TYPE,
    size: "s",
    onClick: () => {
      var _contextMenuRef$curre;
      return (_contextMenuRef$curre = contextMenuRef.current) === null || _contextMenuRef$curre === void 0 ? void 0 : _contextMenuRef$curre.click();
    },
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 7
    }
  }, _translations.TITLE));
};

/**
 * Add to timeline feature, leverages the built-in functionality retrieves from the timeLineService (see ThreatIntelligenceSecuritySolutionContext in x-pack/plugins/threat_intelligence/public/types.ts)
 * Clicking on the button will add a key-value pair to an Untitled timeline.
 *
 * This component is to be used as a cellAction in an {@link EuiDataGrid}.
 *
 * @returns add to timeline button or an empty component
 */
exports.AddToTimelineContextMenu = AddToTimelineContextMenu;
const AddToTimelineCellAction = ({
  data,
  field,
  Component,
  'data-test-subj': dataTestSubj
}) => {
  const {
    application: {
      capabilities
    }
  } = (0, _kibana.useKibana)().services;
  const {
    read: hasAccessToTimeline
  } = (0, _timeline_capabilities.extractTimelineCapabilities)(capabilities);
  const addToTimelineButton = (0, _use_add_to_timeline_button.useAddToTimelineButton)();
  const {
    addToTimelineProps
  } = (0, _use_add_to_timeline.useAddToTimeline)({
    indicator: data,
    field
  });
  if (!hasAccessToTimeline || !addToTimelineProps) {
    return null;
  }
  addToTimelineProps.Component = Component;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 7
    }
  }, addToTimelineButton(addToTimelineProps)));
};
exports.AddToTimelineCellAction = AddToTimelineCellAction;