"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndicatorFieldValue = void 0;
var _react = _interopRequireDefault(require("react"));
var _use_field_types = require("../../../../hooks/use_field_types");
var _common = require("../../../../constants/common");
var _indicator = require("../../../../../../common/threat_intelligence/types/indicator");
var _date_formatter = require("../../../../components/date_formatter");
var _unwrap_value = require("../../utils/unwrap_value");
var _tlp_badge = require("./tlp_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/threat_intelligence/modules/indicators/components/common/field_value.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Takes an indicator object, a field and a field => type object to returns the correct value to display.
 * @returns If the type is a 'date', returns the {@link DateFormatter} component, else returns the value or {@link EMPTY_VALUE}.
 */
const IndicatorFieldValue = ({
  indicator,
  field
}) => {
  const fieldType = (0, _use_field_types.useFieldTypes)()[field];
  const value = (0, _unwrap_value.unwrapValue)(indicator, field);
  if (field === _indicator.RawIndicatorFieldId.MarkingTLP) {
    return /*#__PURE__*/_react.default.createElement(_tlp_badge.TLPBadge, {
      value: value,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 12
      }
    });
  }
  return fieldType === 'date' ? /*#__PURE__*/_react.default.createElement(_date_formatter.DateFormatter, {
    date: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }) : value ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, value) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _common.EMPTY_VALUE);
};
exports.IndicatorFieldValue = IndicatorFieldValue;