"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Sourcerer = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var i18n = _interopRequireWildcard(require("./translations"));
var _store = require("../store");
var _model = require("../store/model");
var _use_pick_index_patterns = require("./use_pick_index_patterns");
var _helpers = require("./helpers");
var _temporary = require("./temporary");
var _containers = require("../containers");
var _use_update_data_view = require("./use_update_data_view");
var _trigger = require("./trigger");
var _sub_components = require("./sub_components");
var _use_signal_helpers = require("../containers/use_signal_helpers");
var _global_query_string = require("../../common/utils/global_query_string");
var _use_url_state = require("../../common/hooks/use_url_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/sourcerer/components/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SourcererPopover = /*#__PURE__*/_react.default.memo(({
  showSourcerer,
  activePatterns,
  isTriggerDisabled,
  isModified,
  isOnlyDetectionAlerts,
  isPopoverOpen,
  loading,
  setPopoverIsOpenCb,
  selectedPatterns,
  signalIndexName,
  handleClosePopOver,
  isTimelineSourcerer,
  selectedDataViewId,
  sourcererMissingPatterns,
  onUpdateDetectionAlertsChecked,
  setMissingPatterns,
  setDataViewId,
  scopeId,
  children
}) => {
  if (!showSourcerer) {
    return null;
  } else if (scopeId === _model.SourcererScopeName.analyzer) {
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "analyzer-sourcerer",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 14
      }
    }, children);
  } else {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      panelClassName: "sourcererPopoverPanel",
      button: /*#__PURE__*/_react.default.createElement(_trigger.Trigger, {
        activePatterns: activePatterns,
        disabled: isTriggerDisabled,
        isModified: isModified,
        isOnlyDetectionAlerts: isOnlyDetectionAlerts,
        isPopoverOpen: isPopoverOpen,
        isTimelineSourcerer: isTimelineSourcerer,
        loading: loading,
        onClick: setPopoverIsOpenCb,
        selectedPatterns: selectedPatterns,
        signalIndexName: signalIndexName,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 96,
          columnNumber: 13
        }
      }),
      closePopover: handleClosePopOver,
      "data-test-subj": isTimelineSourcerer ? 'timeline-sourcerer-popover' : 'sourcerer-popover',
      display: "block",
      isOpen: isPopoverOpen,
      ownFocus: true,
      repositionOnScroll: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children));
  }
});
SourcererPopover.displayName = 'SourcererPopover';

/**
 * @deprecated Use security_solution/public/data_view_manager/components/data_view_picker instead
 */
const Sourcerer = exports.Sourcerer = /*#__PURE__*/_react.default.memo(({
  scope: scopeId
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const isDetectionsSourcerer = scopeId === _model.SourcererScopeName.detections;
  const isTimelineSourcerer = scopeId === _model.SourcererScopeName.timeline;
  const isDefaultSourcerer = scopeId === _model.SourcererScopeName.default;
  const updateUrlParam = (0, _global_query_string.useUpdateUrlParam)(_use_url_state.URL_PARAM_KEY.sourcerer);
  const signalIndexName = (0, _reactRedux.useSelector)(_store.sourcererSelectors.signalIndexName);
  const defaultDataView = (0, _reactRedux.useSelector)(_store.sourcererSelectors.defaultDataView);
  const kibanaDataViews = (0, _reactRedux.useSelector)(_store.sourcererSelectors.kibanaDataViews);
  const selectedDataViewId = (0, _reactRedux.useSelector)(state => {
    return _store.sourcererSelectors.sourcererScopeSelectedDataViewId(state, scopeId);
  });
  const selectedPatterns = (0, _reactRedux.useSelector)(state => {
    return _store.sourcererSelectors.sourcererScopeSelectedPatterns(state, scopeId);
  });
  const sourcererMissingPatterns = (0, _reactRedux.useSelector)(state => {
    return _store.sourcererSelectors.sourcererScopeMissingPatterns(state, scopeId);
  });
  const {
    pollForSignalIndex
  } = (0, _use_signal_helpers.useSignalHelpers)();
  (0, _react.useEffect)(() => {
    if (pollForSignalIndex != null && (isTimelineSourcerer || isDetectionsSourcerer)) {
      pollForSignalIndex();
    }
  }, [isDetectionsSourcerer, isTimelineSourcerer, pollForSignalIndex]);
  const {
    indicesExist,
    loading,
    sourcererDataView
  } = (0, _containers.useSourcererDataView)(scopeId);
  const activePatterns = (0, _react.useMemo)(() => {
    var _ref;
    return (_ref = sourcererDataView.title || '') === null || _ref === void 0 ? void 0 : _ref.split(',').filter(Boolean);
  }, [sourcererDataView.title]);
  const [missingPatterns, setMissingPatterns] = (0, _react.useState)(activePatterns && activePatterns.length > 0 ? sourcererMissingPatterns.filter(p => activePatterns.includes(p)) : []);
  (0, _react.useEffect)(() => {
    if (activePatterns && activePatterns.length > 0) {
      setMissingPatterns(sourcererMissingPatterns.filter(p => activePatterns.includes(p)));
    }
  }, [activePatterns, sourcererMissingPatterns]);
  const [isOnlyDetectionAlertsChecked, setIsOnlyDetectionAlertsChecked] = (0, _react.useState)(isTimelineSourcerer && selectedPatterns.join() === signalIndexName);
  const onUpdateDetectionAlertsChecked = (0, _react.useCallback)(() => {
    setIsOnlyDetectionAlertsChecked(isTimelineSourcerer && selectedPatterns.join() === signalIndexName);
  }, [isTimelineSourcerer, selectedPatterns, signalIndexName]);
  (0, _react.useEffect)(() => {
    onUpdateDetectionAlertsChecked();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [selectedPatterns]);
  const isOnlyDetectionAlerts = isDetectionsSourcerer || isTimelineSourcerer && isOnlyDetectionAlertsChecked;
  const [isPopoverOpen, setPopoverIsOpen] = (0, _react.useState)(false);
  const [dataViewId, setDataViewId] = (0, _react.useState)(selectedDataViewId);
  const {
    allOptions,
    dataViewSelectOptions,
    loadingIndexPatterns,
    isModified,
    handleOutsideClick,
    onChangeCombo: onChangeIndexPatterns,
    renderOption,
    selectedOptions,
    setIndexPatternsByDataView
  } = (0, _use_pick_index_patterns.usePickIndexPatterns)({
    dataViewId,
    defaultDataViewId: defaultDataView.id,
    isOnlyDetectionAlerts,
    kibanaDataViews,
    missingPatterns,
    scopeId,
    selectedDataViewId,
    selectedPatterns,
    signalIndexName
  });
  const onCheckboxChanged = (0, _react.useCallback)(e => {
    setIsOnlyDetectionAlertsChecked(e.target.checked);
    setDataViewId(defaultDataView.id);
    setIndexPatternsByDataView(defaultDataView.id, e.target.checked);
  }, [defaultDataView.id, setIndexPatternsByDataView]);
  const [expandAdvancedOptions, setExpandAdvancedOptions] = (0, _react.useState)(false);
  const [isShowingUpdateModal, setIsShowingUpdateModal] = (0, _react.useState)(false);
  const setPopoverIsOpenCb = (0, _react.useCallback)(() => {
    setPopoverIsOpen(prevState => !prevState);
    setExpandAdvancedOptions(false); // we always want setExpandAdvancedOptions collapsed by default when popover opened
  }, []);
  const dispatchChangeDataView = (0, _react.useCallback)((newSelectedDataView, newSelectedPatterns, shouldValidateSelectedPatterns) => {
    dispatch(_store.sourcererActions.setSelectedDataView({
      id: scopeId,
      selectedDataViewId: newSelectedDataView,
      selectedPatterns: newSelectedPatterns,
      shouldValidateSelectedPatterns
    }));
    if (isDefaultSourcerer) {
      updateUrlParam({
        [_model.SourcererScopeName.default]: {
          id: newSelectedDataView,
          selectedPatterns: newSelectedPatterns
        }
      });
    }
  }, [dispatch, scopeId, isDefaultSourcerer, updateUrlParam]);
  const onChangeDataView = (0, _react.useCallback)(newSelectedOption => {
    setDataViewId(newSelectedOption);
    setIndexPatternsByDataView(newSelectedOption);
  }, [setIndexPatternsByDataView]);
  const resetDataSources = (0, _react.useCallback)(() => {
    setDataViewId(defaultDataView.id);
    setIndexPatternsByDataView(defaultDataView.id);
    setIsOnlyDetectionAlertsChecked(false);
    setMissingPatterns([]);
  }, [defaultDataView.id, setIndexPatternsByDataView]);
  const handleSaveIndices = (0, _react.useCallback)(() => {
    const patterns = selectedOptions.map(so => so.label);
    if (dataViewId != null) {
      dispatchChangeDataView(dataViewId, patterns);
    }
    setPopoverIsOpen(false);
  }, [dispatchChangeDataView, dataViewId, selectedOptions]);
  const handleClosePopOver = (0, _react.useCallback)(() => {
    handleOutsideClick();
    setDataViewId(selectedDataViewId);
    setMissingPatterns(sourcererMissingPatterns);
    onUpdateDetectionAlertsChecked();
    setPopoverIsOpen(false);
    setExpandAdvancedOptions(false);
  }, [handleOutsideClick, onUpdateDetectionAlertsChecked, selectedDataViewId, sourcererMissingPatterns]);

  // deprecated timeline index pattern handlers
  const onContinueUpdateDeprecated = (0, _react.useCallback)(() => {
    setIsShowingUpdateModal(false);
    const patterns = selectedPatterns.filter(pattern => defaultDataView.patternList.includes(pattern));
    dispatchChangeDataView(defaultDataView.id, patterns);
    setPopoverIsOpen(false);
  }, [defaultDataView.id, defaultDataView.patternList, dispatchChangeDataView, selectedPatterns]);
  const onUpdateDeprecated = (0, _react.useCallback)(() => {
    // are all the patterns in the default?
    if (missingPatterns.length === 0) {
      onContinueUpdateDeprecated();
    } else {
      // open modal
      setIsShowingUpdateModal(true);
    }
  }, [missingPatterns, onContinueUpdateDeprecated]);
  const [isTriggerDisabled, setIsTriggerDisabled] = (0, _react.useState)(false);
  const onOpenAndReset = (0, _react.useCallback)(() => {
    setPopoverIsOpen(true);
    resetDataSources();
  }, [resetDataSources]);
  const updateDataView = (0, _use_update_data_view.useUpdateDataView)(onOpenAndReset);
  const onUpdateDataView = (0, _react.useCallback)(async () => {
    const isUiSettingsSuccess = await updateDataView(missingPatterns);
    setIsShowingUpdateModal(false);
    setPopoverIsOpen(false);
    if (isUiSettingsSuccess) {
      dispatchChangeDataView(defaultDataView.id, // to be at this stage, activePatterns is defined, the ?? selectedPatterns is to make TS happy
      activePatterns !== null && activePatterns !== void 0 ? activePatterns : selectedPatterns, false);
      setIsTriggerDisabled(true);
    }
  }, [activePatterns, defaultDataView.id, missingPatterns, dispatchChangeDataView, selectedPatterns, updateDataView]);
  (0, _react.useEffect)(() => {
    setDataViewId(selectedDataViewId);
  }, [selectedDataViewId]);
  const onExpandAdvancedOptionsClicked = (0, _react.useCallback)(() => {
    setExpandAdvancedOptions(prevState => !prevState);
  }, []);
  const showSourcerer = (0, _react.useMemo)(() => {
    return indicesExist || [_model.SourcererScopeName.analyzer, _model.SourcererScopeName.timeline].includes(scopeId);
  }, [indicesExist, scopeId]);
  return /*#__PURE__*/_react.default.createElement(SourcererPopover, {
    showSourcerer: showSourcerer,
    activePatterns: activePatterns,
    isTriggerDisabled: isTriggerDisabled,
    isModified: isModified,
    isOnlyDetectionAlerts: isOnlyDetectionAlerts,
    isPopoverOpen: isPopoverOpen,
    isTimelineSourcerer: isTimelineSourcerer,
    loading: loading,
    handleOutsideClick: handleOutsideClick,
    setPopoverIsOpenCb: setPopoverIsOpenCb,
    selectedPatterns: selectedPatterns,
    signalIndexName: signalIndexName,
    handleClosePopOver: handleClosePopOver,
    selectedDataViewId: selectedDataViewId,
    sourcererMissingPatterns: sourcererMissingPatterns,
    onUpdateDetectionAlertsChecked: onUpdateDetectionAlertsChecked,
    setMissingPatterns: setMissingPatterns,
    setDataViewId: setDataViewId,
    scopeId: scopeId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 363,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_helpers.PopoverContent, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 384,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    "data-test-subj": "sourcerer-title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 385,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.SELECT_DATA_VIEW)), /*#__PURE__*/_react.default.createElement(_sub_components.SourcererCallout, {
    isOnlyDetectionAlerts: isOnlyDetectionAlerts,
    title: isTimelineSourcerer ? i18n.CALL_OUT_TIMELINE_TITLE : i18n.CALL_OUT_TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 388,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 392,
      columnNumber: 9
    }
  }), dataViewId === null && isModified === 'deprecated' || isModified === 'missingPatterns' ? /*#__PURE__*/_react.default.createElement(_temporary.TemporarySourcerer, {
    activePatterns: activePatterns,
    indicesExist: indicesExist,
    isModified: isModified,
    isShowingUpdateModal: isShowingUpdateModal,
    missingPatterns: missingPatterns,
    onContinueWithoutUpdate: onContinueUpdateDeprecated,
    onDismiss: setPopoverIsOpenCb,
    onDismissModal: () => setIsShowingUpdateModal(false),
    onReset: resetDataSources,
    onUpdateStepOne: isModified === 'deprecated' ? onUpdateDeprecated : onUpdateDataView,
    onUpdateStepTwo: onUpdateDataView,
    selectedPatterns: selectedPatterns,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 395,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 410,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sub_components.AlertsCheckbox, {
    isShow: isTimelineSourcerer,
    checked: isOnlyDetectionAlertsChecked,
    onChange: onCheckboxChanged,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 412,
      columnNumber: 15
    }
  }), dataViewId && /*#__PURE__*/_react.default.createElement(_helpers.StyledFormRow, {
    label: i18n.INDEX_PATTERNS_CHOOSE_DATA_VIEW_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 418,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    "data-test-subj": "sourcerer-select",
    isLoading: loadingIndexPatterns,
    disabled: isOnlyDetectionAlerts,
    fullWidth: true,
    onChange: onChangeDataView,
    options: dataViewSelectOptions,
    placeholder: i18n.INDEX_PATTERNS_CHOOSE_DATA_VIEW_LABEL,
    valueOfSelected: dataViewId,
    "aria-label": i18n.INDEX_PATTERNS_CHOOSE_DATA_VIEW_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 419,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 433,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_helpers.StyledButtonEmpty, {
    color: "text",
    "data-test-subj": "sourcerer-advanced-options-toggle",
    iconType: expandAdvancedOptions ? 'arrowDown' : 'arrowRight',
    onClick: onExpandAdvancedOptionsClicked,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 434,
      columnNumber: 15
    }
  }, i18n.INDEX_PATTERNS_ADVANCED_OPTIONS_TITLE), expandAdvancedOptions && /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 442,
      columnNumber: 41
    }
  }), /*#__PURE__*/_react.default.createElement(_helpers.FormRow, {
    isDisabled: loadingIndexPatterns,
    $expandAdvancedOptions: expandAdvancedOptions,
    helpText: isOnlyDetectionAlerts ? undefined : i18n.INDEX_PATTERNS_DESCRIPTIONS,
    label: i18n.INDEX_PATTERNS_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 443,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "sourcerer-combo-box",
    fullWidth: true,
    isDisabled: isOnlyDetectionAlerts || loadingIndexPatterns,
    onChange: onChangeIndexPatterns,
    options: allOptions,
    placeholder: i18n.PICK_INDEX_PATTERNS,
    renderOption: renderOption,
    selectedOptions: selectedOptions,
    "aria-label": i18n.INDEX_PATTERNS_LABEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 449,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_sub_components.SaveButtons, {
    disableSave: selectedOptions.length === 0,
    isShow: !isDetectionsSourcerer,
    onReset: resetDataSources,
    onSave: handleSaveIndices,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 462,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 469,
      columnNumber: 13
    }
  }))));
});
Sourcerer.displayName = 'Sourcerer';