"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.START_RULES_MIGRATION_DIALOG_TITLE = exports.START_RULES_MIGRATION_DIALOG_PREBUILT_RULES_LABEL = exports.START_RULES_MIGRATION_DIALOG_DESCRIPTION = exports.RETRY_RULES_MIGRATION_DIALOG_TITLE = exports.RETRY_RULES_MIGRATION_DIALOG_DESCRIPTION = exports.REPROCESS_RULES_MIGRATION_DIALOG_TITLE = exports.REPROCESS_RULES_MIGRATION_DIALOG_DESCRIPTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const START_RULES_MIGRATION_DIALOG_TITLE = exports.START_RULES_MIGRATION_DIALOG_TITLE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.startMigrationDialog.title', {
  defaultMessage: 'Migrate rules'
});
const START_RULES_MIGRATION_DIALOG_DESCRIPTION = exports.START_RULES_MIGRATION_DIALOG_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.startMigrationDialog.description', {
  defaultMessage: 'You are about to start a migration. Select which AI connector to use.'
});
const RETRY_RULES_MIGRATION_DIALOG_TITLE = exports.RETRY_RULES_MIGRATION_DIALOG_TITLE = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.retryMigrationDialog.title', {
  defaultMessage: 'Retry rules migration'
});
const RETRY_RULES_MIGRATION_DIALOG_DESCRIPTION = exports.RETRY_RULES_MIGRATION_DIALOG_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.retryMigrationDialog.description', {
  defaultMessage: 'You are about to retry a migration, which will use additional tokens. Select which AI connector to use.'
});
const REPROCESS_RULES_MIGRATION_DIALOG_TITLE = count => _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.reprocessDialog.title', {
  defaultMessage: 'Reprocess {count} {count, plural, one {rule} other {rules}}',
  values: {
    count
  }
});
exports.REPROCESS_RULES_MIGRATION_DIALOG_TITLE = REPROCESS_RULES_MIGRATION_DIALOG_TITLE;
const REPROCESS_RULES_MIGRATION_DIALOG_DESCRIPTION = exports.REPROCESS_RULES_MIGRATION_DIALOG_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.reprocessDialog.description', {
  defaultMessage: 'You are about to reprocess all failed rules, which will use additional tokens. Select which AI connector to use. Optionally, you have the ability to not match prebuilt rules.'
});
const START_RULES_MIGRATION_DIALOG_PREBUILT_RULES_LABEL = exports.START_RULES_MIGRATION_DIALOG_PREBUILT_RULES_LABEL = _i18n.i18n.translate('xpack.securitySolution.siemMigrations.rules.startMigrationDialog.prebuiltRulesLabel', {
  defaultMessage: 'Match to Elastic prebuilt rules'
});