"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexPatternPlaceholderFormWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../shared_imports");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/rules/components/rules_table/update_index_pattern/flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const IndexPatternPlaceholderFormWrapper = exports.IndexPatternPlaceholderFormWrapper = /*#__PURE__*/(0, _react.memo)(({
  form,
  title,
  banner,
  children,
  onClose,
  onSubmit,
  flyoutSize = 's'
}) => {
  const simpleFlyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'IndexPatternPlaceholderForm'
  });
  const {
    isValid
  } = form;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: onClose,
    "aria-labelledby": simpleFlyoutTitleId,
    size: flyoutSize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    "data-test-subj": "indexPatternPlaceholderFormTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: simpleFlyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 13
    }
  }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    banner: banner,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  }, children)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    flush: "left",
    "data-test-subj": "indexPatternPlaceholderFormCancelBtn",
    "aria-label": i18n.INDEX_PATTERN_PLACEHOLDER_FORM_CANCEL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 15
    }
  }, i18n.INDEX_PATTERN_PLACEHOLDER_FORM_CANCEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => onSubmit(form.getFormData().index.join(',')),
    fill: true
    // The `isValid` is set to `undefined` on initialization. Until value is changed we show the `Save` button as disabled.
    // Once value is updated the form will go through the validation cycle and will update `isValid` state.
    // In case form is invalid, we disable button as well.
    ,
    disabled: isValid !== true,
    "data-test-subj": "indexPatternPlaceholderFormSaveBtn",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 15
    }
  }, i18n.INDEX_PATTERN_PLACEHOLDER_FORM_SAVE)))));
});
IndexPatternPlaceholderFormWrapper.displayName = 'IndexPatternPlaceholderFormWrapper';