"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatusBadge = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _constants = require("../../../../../common/siem_migrations/constants");
var _translation_results = require("../../../common/utils/translation_results");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/dashboards/components/status_badge/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const statusTextWrapperClassName = (0, _css.css)`
  width: 100%;
  display: inline-grid;
`;
const StatusBadge = exports.StatusBadge = /*#__PURE__*/_react.default.memo(({
  dashboard,
  'data-test-subj': dataTestSubj = 'translation-result'
}) => {
  var _dashboard$elastic_da, _dashboard$translatio;
  const colors = (0, _translation_results.useResultVisColors)();
  // Installed
  if ((_dashboard$elastic_da = dashboard.elastic_dashboard) !== null && _dashboard$elastic_da !== void 0 && _dashboard$elastic_da.id) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      "data-test-subj": "installedStatusTooltip",
      content: i18n.DASHBOARD_STATUS_INSTALLED,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "check",
      color: colors[_constants.MigrationTranslationResult.FULL],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      "data-test-subj": dataTestSubj,
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 13
      }
    }, i18n.DASHBOARD_STATUS_INSTALLED)));
  }

  // Failed
  if (dashboard.status === _constants.SiemMigrationStatus.FAILED) {
    var _dashboard$comments;
    const tooltipMessage = (_dashboard$comments = dashboard.comments) !== null && _dashboard$comments !== void 0 && _dashboard$comments.length ? dashboard.comments[0].message : i18n.DASHBOARD_STATUS_FAILED;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      "data-test-subj": "failedStatusTooltip",
      content: tooltipMessage,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "warningFilled",
      color: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      "data-test-subj": dataTestSubj,
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 13
      }
    }, i18n.DASHBOARD_STATUS_FAILED)));
  }
  const translationResult = (_dashboard$translatio = dashboard.translation_result) !== null && _dashboard$translatio !== void 0 ? _dashboard$translatio : 'untranslatable';
  const displayValue = (0, _translation_results.convertTranslationResultIntoText)(translationResult);
  const color = colors[translationResult];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    "data-test-subj": "translationStatusTooltip",
    content: displayValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: color,
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: statusTextWrapperClassName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "eui-textTruncate",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 13
    }
  }, displayValue))));
});
StatusBadge.displayName = 'StatusBadge';