"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMacrosFileUploadStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_app_toasts = require("../../../../../../../../common/hooks/use_app_toasts");
var _resources = require("../../../../../../../../../common/siem_migrations/dashboards/resources");
var _use_upsert_resources = require("../../../../../../service/hooks/use_upsert_resources");
var _macros_file_upload = require("./macros_file_upload");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/dashboards/components/data_input_flyout/steps/macros/sub_steps/macros_file_upload/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useMacrosFileUploadStep = ({
  status,
  migrationStats,
  missingMacros,
  onMacrosCreated
}) => {
  const {
    addWarning
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    upsertResources,
    isLoading,
    error
  } = (0, _use_upsert_resources.useUpsertResources)(onMacrosCreated);
  const upsertMigrationResources = (0, _react.useCallback)(macrosFromFile => {
    const macrosIndexed = Object.fromEntries(macrosFromFile.map(macro => [macro.name, macro]));
    const resourceIdentifier = new _resources.DashboardResourceIdentifier('splunk');
    const macrosToUpsert = [];
    let missingMacrosIt = missingMacros;
    while (missingMacrosIt.length > 0) {
      const macros = [];
      missingMacrosIt.forEach(macroName => {
        const macro = macrosIndexed[macroName];
        if (macro) {
          macros.push(macro);
        } else {
          // Macro missing from file
        }
      });
      macrosToUpsert.push(...macros);
      missingMacrosIt = resourceIdentifier.fromResources(macros).reduce((acc, resource) => {
        if (resource.type === 'macro') {
          acc.push(resource.name);
        }
        return acc;
      }, []);
    }
    if (macrosToUpsert.length === 0) {
      addWarning({
        title: i18n.NO_MISSING_MACROS_PROVIDED
      });
      return; // No missing macros provided
    }
    upsertResources(migrationStats.id, macrosToUpsert);
  }, [missingMacros, upsertResources, migrationStats.id, addWarning]);
  const uploadStepStatus = (0, _react.useMemo)(() => {
    if (isLoading) {
      return 'loading';
    }
    if (error) {
      return 'danger';
    }
    return status;
  }, [isLoading, error, status]);
  return {
    title: i18n.MACROS_DATA_INPUT_FILE_UPLOAD_TITLE,
    status: uploadStepStatus,
    children: /*#__PURE__*/_react.default.createElement(_macros_file_upload.MacrosFileUpload, {
      createResources: upsertMigrationResources,
      isLoading: isLoading,
      apiError: error === null || error === void 0 ? void 0 : error.message,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 7
      }
    })
  };
};
exports.useMacrosFileUploadStep = useMacrosFileUploadStep;