"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createNameColumn = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../../common/siem_migrations/constants");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/siem_migrations/dashboards/components/dashboard_table_columns/name.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Name = ({
  dashboard,
  openDashboardDetailsFlyout
}) => {
  var _dashboard$elastic_da, _dashboard$elastic_da2;
  const title = (_dashboard$elastic_da = (_dashboard$elastic_da2 = dashboard.elastic_dashboard) === null || _dashboard$elastic_da2 === void 0 ? void 0 : _dashboard$elastic_da2.title) !== null && _dashboard$elastic_da !== void 0 ? _dashboard$elastic_da : dashboard.original_dashboard.title;
  const onClick = (0, _react.useCallback)(() => {
    openDashboardDetailsFlyout(dashboard);
  }, [dashboard, openDashboardDetailsFlyout]);
  if (dashboard.status === _constants.SiemMigrationStatus.FAILED) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": "dashboardNameFailed",
      color: "danger",
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 7
      }
    }, title);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: i18n.VIEW_DASHBOARD_TRANSLATION_SUMMARY_TOOLTIP,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: onClick,
    "data-test-subj": "viewDashboardTranslationSummary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }, title));
};
const createNameColumn = ({
  openDashboardDetailsFlyout
}) => {
  return {
    field: 'original_dashboard.title',
    name: i18n.COLUMN_NAME,
    render: (_, dashboard) => /*#__PURE__*/_react.default.createElement(Name, {
      dashboard: dashboard,
      openDashboardDetailsFlyout: openDashboardDetailsFlyout,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 7
      }
    }),
    sortable: true,
    truncateText: true,
    width: '50%',
    align: 'left'
  };
};
exports.createNameColumn = createNameColumn;