"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesLandingPage = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/usage-collection-plugin/public");
var _eui = require("@elastic/eui");
var _landing_links = require("@kbn/security-solution-navigation/landing_links");
var _common = require("../../common");
var _plugin_template_wrapper = require("../common/components/plugin_template_wrapper");
var _page_wrapper = require("../common/components/page_wrapper");
var _spy_routes = require("../common/utils/route/spy_routes");
var _title = require("../common/components/header_page/title");
var _nav_links = require("../common/links/nav_links");
var _global_query_string = require("../common/utils/global_query_string");
var _trackers = require("../common/lib/telemetry/trackers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/rules/landing.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RULES_PAGE_TITLE = _i18n.i18n.translate('xpack.securitySolution.rules.landing.pageTitle', {
  defaultMessage: 'Rules'
});
const RulesLandingPage = () => {
  var _useRootNavLink;
  const {
    links = [],
    categories = []
  } = (_useRootNavLink = (0, _nav_links.useRootNavLink)(_common.SecurityPageName.rulesLanding)) !== null && _useRootNavLink !== void 0 ? _useRootNavLink : {};
  const urlState = (0, _global_query_string.useGlobalQueryString)();
  return /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
    viewId: _common.SecurityPageName.rulesLanding,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_title.Title, {
    title: RULES_PAGE_TITLE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_landing_links.LandingLinksIconsCategories, {
    links: links,
    categories: categories,
    onLinkClick: _trackers.trackLandingLinkClick,
    urlState: urlState,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _common.SecurityPageName.rulesLanding,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 11
    }
  }))));
};
exports.RulesLandingPage = RulesLandingPage;