"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DescriptiveName = DescriptiveName;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _event = require("../../../../common/endpoint/models/event");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/resolver/view/panels/descriptive_name.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Based on the ECS category of the event, attempt to provide a more descriptive name
 * (e.g. the `event.registry.key` for `registry` or the `dns.question.name` for `dns`, etc.).
 * This function returns the data in the form of `{subject, descriptor}` where `subject` will
 * tend to be the more distinctive term (e.g. 137.213.212.7 for a network event) and the
 * `descriptor` can be used to present more useful/meaningful view (e.g. `inbound 137.213.212.7`
 * in the example above).
 * see: https://www.elastic.co/guide/en/ecs/current/ecs-field-reference.html
 * @param event The ResolverEvent to get the descriptive name for
 */
function DescriptiveName({
  event
}) {
  var _event$network, _event$kibana, _event$kibana$alert, _event$kibana$alert$r, _event$file, _event$registry, _event$registry3, _event$dns, _event$dns$question;
  if ((0, _event.isLegacyEventSafeVersion)(event)) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.resolver.eventDescription.legacyEventLabel",
      defaultMessage: "{ processName }",
      values: {
        processName: (0, _event.processNameSafeVersion)(event)
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 31,
        columnNumber: 7
      }
    });
  }

  /**
   * This list of attempts can be expanded/adjusted as the underlying model changes over time:
   */

  // Stable, per ECS 1.5: https://www.elastic.co/guide/en/ecs/current/ecs-allowed-values-event-category.html

  if ((_event$network = event.network) !== null && _event$network !== void 0 && _event$network.forwarded_ip) {
    var _event$network2, _event$network3;
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.resolver.eventDescription.networkEventLabel",
      defaultMessage: "{ networkDirection } { forwardedIP }",
      values: {
        forwardedIP: String((_event$network2 = event.network) === null || _event$network2 === void 0 ? void 0 : _event$network2.forwarded_ip),
        networkDirection: String((_event$network3 = event.network) === null || _event$network3 === void 0 ? void 0 : _event$network3.direction)
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 7
      }
    });
  }
  if ((_event$kibana = event.kibana) !== null && _event$kibana !== void 0 && (_event$kibana$alert = _event$kibana.alert) !== null && _event$kibana$alert !== void 0 && (_event$kibana$alert$r = _event$kibana$alert.rule) !== null && _event$kibana$alert$r !== void 0 && _event$kibana$alert$r.name) {
    var _event$kibana2, _event$kibana2$alert, _event$kibana2$alert$;
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.resolver.eventDescription.alertEventNameLabel",
      defaultMessage: "{ ruleName }",
      values: {
        ruleName: String((_event$kibana2 = event.kibana) === null || _event$kibana2 === void 0 ? void 0 : (_event$kibana2$alert = _event$kibana2.alert) === null || _event$kibana2$alert === void 0 ? void 0 : (_event$kibana2$alert$ = _event$kibana2$alert.rule) === null || _event$kibana2$alert$ === void 0 ? void 0 : _event$kibana2$alert$.name)
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 7
      }
    });
  }
  if ((_event$file = event.file) !== null && _event$file !== void 0 && _event$file.path) {
    var _event$file2;
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.resolver.eventDescription.fileEventLabel",
      defaultMessage: "{ filePath }",
      values: {
        filePath: String((_event$file2 = event.file) === null || _event$file2 === void 0 ? void 0 : _event$file2.path)
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 7
      }
    });
  }
  if ((_event$registry = event.registry) !== null && _event$registry !== void 0 && _event$registry.path) {
    var _event$registry2;
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.resolver.eventDescription.registryPathLabel",
      defaultMessage: "{ registryPath }",
      values: {
        registryPath: String((_event$registry2 = event.registry) === null || _event$registry2 === void 0 ? void 0 : _event$registry2.path)
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 7
      }
    });
  }
  if ((_event$registry3 = event.registry) !== null && _event$registry3 !== void 0 && _event$registry3.key) {
    var _event$registry4;
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.resolver.eventDescription.registryKeyLabel",
      defaultMessage: "{ registryKey }",
      values: {
        registryKey: String((_event$registry4 = event.registry) === null || _event$registry4 === void 0 ? void 0 : _event$registry4.key)
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 7
      }
    });
  }
  if ((_event$dns = event.dns) !== null && _event$dns !== void 0 && (_event$dns$question = _event$dns.question) !== null && _event$dns$question !== void 0 && _event$dns$question.name) {
    var _event$dns2, _event$dns2$question;
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.resolver.eventDescription.dnsQuestionNameLabel",
      defaultMessage: "{ dnsQuestionName }",
      values: {
        dnsQuestionName: String((_event$dns2 = event.dns) === null || _event$dns2 === void 0 ? void 0 : (_event$dns2$question = _event$dns2.question) === null || _event$dns2$question === void 0 ? void 0 : _event$dns2$question.name)
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.resolver.eventDescription.entityIDLabel",
    defaultMessage: "{ entityID }",
    values: {
      entityID: (0, _event.entityIDSafeVersion)(event)
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 5
    }
  });
}