"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Breadcrumbs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styles = require("./styles");
var _use_colors = require("../use_colors");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/resolver/view/panels/breadcrumbs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Breadcrumb menu
 */
// eslint-disable-next-line react/display-name
const Breadcrumbs = exports.Breadcrumbs = /*#__PURE__*/(0, _react.memo)(function ({
  breadcrumbs
}) {
  // Just tagging the last crumb with `data-test-subj` for testing
  const crumbsWithLastSubject = (0, _react.useMemo)(() => {
    const lastcrumb = breadcrumbs.slice(-1).map(crumb => {
      crumb['data-test-subj'] = 'resolver:breadcrumbs:last';
      // Manually set here as setting truncate={true} on ThemedBreadcrumbs truncates all parts of the full path
      crumb.truncate = true;
      return crumb;
    });
    return [...breadcrumbs.slice(0, -1), ...lastcrumb];
  }, [breadcrumbs]);
  const {
    resolverBreadcrumbBackground,
    resolverEdgeText
  } = (0, _use_colors.useColors)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_styles.ThemedBreadcrumbs, {
    background: resolverBreadcrumbBackground,
    text: resolverEdgeText,
    breadcrumbs: crumbsWithLastSubject,
    truncate: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }));
});