"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeneratedText = void 0;
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/resolver/view/generated_text.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * A component that renders an element with breaking opportunities (`<wbr>`s)
 * spliced into text children at word boundaries.
 */
// eslint-disable-next-line react/display-name
const GeneratedText = exports.GeneratedText = /*#__PURE__*/_react.default.memo(function ({
  children
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, processedValue());
  function processedValue() {
    return _react.default.Children.map(children, child => {
      if (typeof child === 'string') {
        const valueSplitByWordBoundaries = child.split(/\b/);
        if (valueSplitByWordBoundaries.length < 2) {
          return valueSplitByWordBoundaries[0];
        }
        return [valueSplitByWordBoundaries[0], ...valueSplitByWordBoundaries.splice(1).reduce(function (generatedTextMemo, value) {
          return [...generatedTextMemo, value, /*#__PURE__*/_react.default.createElement("wbr", {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 32,
              columnNumber: 52
            }
          })];
        }, [])];
      } else {
        return child;
      }
    });
  }
});