"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventsByDataset = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _charts = require("@elastic/charts");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _react = _interopRequireWildcard(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/data-plugin/common");
var _constants = require("../../../../common/constants");
var _translations = require("../../../common/components/events_viewer/translations");
var _redirect_to_hosts = require("../../../common/components/link_to/redirect_to_hosts");
var _matrix_histogram = require("../../../common/components/matrix_histogram");
var _kuery = require("../../../common/lib/kuery");
var _kibana = require("../../../common/lib/kibana");
var _histogram_configurations = require("../../../common/components/events_tab/histogram_configurations");
var _model = require("../../../explore/hosts/store/model");
var i18n = _interopRequireWildcard(require("../../pages/translations"));
var _types = require("../../../app/types");
var _link_to = require("../../../common/components/link_to");
var _use_invalid_filter_query = require("../../../common/hooks/use_invalid_filter_query");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/overview/components/events_by_dataset/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_STACK_BY = _histogram_configurations.NO_BREAKDOWN_STACK_BY_VALUE;
const ID = 'eventsByDatasetOverview';
const CHART_HEIGHT = 160;
const getHistogramOption = fieldName => ({
  text: fieldName,
  value: fieldName
});
const StyledLinkButton = (0, _styled.default)(_eui.EuiButton)`
  margin-left: 0;
  @media only screen and (min-width: ${props => props.theme.euiTheme.breakpoint.m}) {
    margin-left: ${({
  theme
}) => theme.euiTheme.size.l};
  }
`;
const EventsByDatasetComponent = ({
  filterQuery: filterQueryFromProps,
  deleteQuery,
  filters,
  from,
  headerChildren,
  dataViewSpec,
  dataView,
  onlyField,
  paddingSize,
  query,
  queryType,
  showSpacer = true,
  sourcererScopeId,
  to,
  hideQueryToggle = false,
  applyGlobalQueriesAndFilters
}) => {
  const uniqueQueryId = (0, _react.useMemo)(() => `${ID}-${queryType}`, [queryType]);
  (0, _react.useEffect)(() => {
    return () => {
      if (deleteQuery) {
        deleteQuery({
          id: uniqueQueryId
        });
      }
    };
  }, [deleteQuery, uniqueQueryId]);
  const kibana = (0, _kibana.useKibana)();
  const {
    formatUrl,
    search: urlSearch
  } = (0, _link_to.useFormatUrl)(_types.SecurityPageName.hosts);
  const {
    navigateToApp
  } = kibana.services.application;
  const [defaultNumberFormat] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_NUMBER_FORMAT);
  const goToHostEvents = (0, _react.useCallback)(ev => {
    ev.preventDefault();
    navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _types.SecurityPageName.hosts,
      path: (0, _redirect_to_hosts.getTabsOnHostsUrl)(_model.HostsTableType.events, urlSearch)
    });
  }, [navigateToApp, urlSearch]);
  const eventsCountViewEventsButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(StyledLinkButton, {
    onClick: goToHostEvents,
    href: formatUrl((0, _redirect_to_hosts.getTabsOnHostsUrl)(_model.HostsTableType.events)),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }, i18n.VIEW_EVENTS), [goToHostEvents, formatUrl]);
  const [filterQuery, kqlError] = (0, _react.useMemo)(() => {
    if (filterQueryFromProps == null) {
      return (0, _kuery.convertToBuildEsQuery)({
        config: (0, _common.getEsQueryConfig)(kibana.services.uiSettings),
        dataViewSpec,
        dataView,
        queries: [query],
        filters
      });
    }
    return [filterQueryFromProps];
  }, [filterQueryFromProps, kibana.services.uiSettings, dataViewSpec, dataView, query, filters]);
  (0, _use_invalid_filter_query.useInvalidFilterQuery)({
    id: uniqueQueryId,
    filterQuery,
    kqlError,
    query,
    startDate: from,
    endDate: to
  });
  const eventsByDatasetHistogramConfigs = (0, _react.useMemo)(() => {
    var _eventsStackByOptions;
    return {
      ..._histogram_configurations.eventsHistogramConfig,
      stackByOptions: onlyField != null ? [getHistogramOption(onlyField)] : _histogram_configurations.eventsHistogramConfig.stackByOptions,
      defaultStackByOption: onlyField != null ? getHistogramOption(onlyField) : (_eventsStackByOptions = _histogram_configurations.eventsStackByOptions.find(o => o.value === DEFAULT_STACK_BY)) !== null && _eventsStackByOptions !== void 0 ? _eventsStackByOptions : _histogram_configurations.eventsStackByOptions[0],
      legendPosition: _charts.Position.Right,
      subtitle: totalCount => `${_translations.SHOWING}: ${(0, _numeral.default)(totalCount).format(defaultNumberFormat)} ${(0, _translations.UNIT)(totalCount)}`,
      titleSize: onlyField == null ? 'm' : 's'
    };
  }, [onlyField, defaultNumberFormat]);
  const headerContent = (0, _react.useMemo)(() => {
    if (onlyField == null || headerChildren != null) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, headerChildren, onlyField == null && eventsCountViewEventsButton);
    } else {
      return null;
    }
  }, [onlyField, headerChildren, eventsCountViewEventsButton]);
  return /*#__PURE__*/_react.default.createElement(_matrix_histogram.MatrixHistogram, (0, _extends2.default)({
    endDate: to,
    filterQuery: filterQuery,
    headerChildren: headerContent,
    id: uniqueQueryId,
    paddingSize: paddingSize,
    showSpacer: showSpacer,
    startDate: from,
    sourcererScopeId: sourcererScopeId
  }, eventsByDatasetHistogramConfigs, {
    title: onlyField != null ? i18n.TOP(onlyField) : eventsByDatasetHistogramConfigs.title,
    chartHeight: CHART_HEIGHT,
    hideQueryToggle: hideQueryToggle,
    applyGlobalQueriesAndFilters: applyGlobalQueriesAndFilters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 5
    }
  }));
};
EventsByDatasetComponent.displayName = 'EventsByDatasetComponent';
const EventsByDataset = exports.EventsByDataset = /*#__PURE__*/_react.default.memo(EventsByDatasetComponent);