"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetTableColumns = exports.RuleAlertsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _constants = require("../../../../app/actions/constants");
var _use_navigate_to_alerts_page_with_filters = require("../../../../common/hooks/use_navigate_to_alerts_page_with_filters");
var _header_section = require("../../../../common/components/header_section");
var i18n = _interopRequireWildcard(require("../translations"));
var _use_rule_alerts_items = require("./use_rule_alerts_items");
var _kibana = require("../../../../common/lib/kibana");
var _constants2 = require("../../../../../common/constants");
var _query_toggle = require("../../../../common/containers/query_toggle");
var _hover_visibility_container = require("../../../../common/components/hover_visibility_container");
var _inspect = require("../../../../common/components/inspect");
var _last_updated_at = require("../../../../common/components/last_updated_at");
var _formatted_number = require("../../../../common/components/formatted_number");
var _cell_actions = require("../../../../common/components/cell_actions");
var _use_global_filter_query = require("../../../../common/hooks/use_global_filter_query");
var _model = require("../../../../sourcerer/store/model");
var _risk_color_palette = require("../../../../common/utils/risk_color_palette");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/overview/components/detection_response/rule_alerts_table/rule_alerts_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DETECTION_RESPONSE_RULE_ALERTS_QUERY_ID = 'detection-response-rule-alerts-severity-table';
const useGetTableColumns = ({
  getAppUrl,
  navigateTo,
  openRuleInAlertsPage
}) => {
  const severityColors = (0, _risk_color_palette.useRiskSeverityColors)();
  return (0, _react.useMemo)(() => [{
    field: 'name',
    name: i18n.RULE_ALERTS_COLUMN_RULE_NAME,
    render: (name, {
      id
    }) => {
      const url = getAppUrl({
        deepLinkId: _constants2.SecurityPageName.rules,
        path: `id/${id}`
      });
      return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        "data-test-subj": `${id}-tooltip`,
        title: i18n.OPEN_RULE_DETAIL_TOOLTIP,
        content: name,
        anchorClassName: "eui-textTruncate",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 71,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "severityRuleAlertsTable-name",
        href: url,
        onClick: ev => {
          if (ev) {
            ev.preventDefault();
          }
          navigateTo({
            url
          });
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 78,
          columnNumber: 15
        }
      }, name));
    }
  }, {
    field: 'last_alert_at',
    name: i18n.RULE_ALERTS_COLUMN_LAST_ALERT,
    'data-test-subj': 'severityRuleAlertsTable-lastAlertAt',
    render: lastAlertAt => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
      value: new Date(lastAlertAt),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 42
      }
    })
  }, {
    field: 'alert_count',
    name: i18n.RULE_ALERTS_COLUMN_ALERT_COUNT,
    'data-test-subj': 'severityRuleAlertsTable-alertCount',
    render: (alertCount, {
      name
    }) => /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
      data: {
        value: name,
        field: _ruleDataUtils.ALERT_RULE_NAME
      },
      mode: _cell_actions.CellActionsMode.HOVER_RIGHT,
      triggerId: _constants.SecurityCellActionsTrigger.ALERTS_COUNT,
      sourcererScopeId: _model.SourcererScopeName.detections,
      metadata: {
        andFilters: [{
          field: 'kibana.alert.workflow_status',
          value: 'open'
        }]
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "severityRuleAlertsTable-alertCountLink",
      disabled: alertCount === 0,
      onClick: () => openRuleInAlertsPage(name),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_formatted_number.FormattedCount, {
      count: alertCount,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 15
      }
    })))
  }, {
    field: 'severity',
    name: i18n.RULE_ALERTS_COLUMN_SEVERITY,
    'data-test-subj': 'severityRuleAlertsTable-severity',
    render: severity => /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: severityColors[severity],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 11
      }
    }, (0, _lodash.capitalize)(severity))
  }], [getAppUrl, navigateTo, openRuleInAlertsPage, severityColors]);
};
exports.useGetTableColumns = useGetTableColumns;
const RuleAlertsTable = exports.RuleAlertsTable = /*#__PURE__*/_react.default.memo(({
  signalIndexName
}) => {
  const {
    getAppUrl,
    navigateTo
  } = (0, _kibana.useNavigation)();
  const {
    toggleStatus,
    setToggleStatus
  } = (0, _query_toggle.useQueryToggle)(DETECTION_RESPONSE_RULE_ALERTS_QUERY_ID);
  const {
    filterQuery
  } = (0, _use_global_filter_query.useGlobalFilterQuery)();
  const {
    items,
    isLoading,
    updatedAt
  } = (0, _use_rule_alerts_items.useRuleAlertsItems)({
    signalIndexName,
    queryId: DETECTION_RESPONSE_RULE_ALERTS_QUERY_ID,
    skip: !toggleStatus,
    filterQuery
  });
  const openAlertsPageWithFilter = (0, _use_navigate_to_alerts_page_with_filters.useNavigateToAlertsPageWithFilters)();
  const openRuleInAlertsPage = (0, _react.useCallback)(ruleName => openAlertsPageWithFilter({
    title: i18n.OPEN_IN_ALERTS_TITLE_RULENAME,
    selectedOptions: [ruleName],
    fieldName: _ruleDataUtils.ALERT_RULE_NAME
  }), [openAlertsPageWithFilter]);
  const navigateToAlerts = (0, _react.useCallback)(() => {
    openAlertsPageWithFilter({
      title: i18n.OPEN_IN_ALERTS_TITLE_STATUS,
      selectedOptions: ['open'],
      fieldName: _ruleDataUtils.ALERT_WORKFLOW_STATUS
    });
  }, [openAlertsPageWithFilter]);
  const columns = useGetTableColumns({
    getAppUrl,
    navigateTo,
    openRuleInAlertsPage
  });
  return /*#__PURE__*/_react.default.createElement(_hover_visibility_container.HoverVisibilityContainer, {
    show: true,
    targetClassNames: [_inspect.BUTTON_CLASS],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    "data-test-subj": "severityRuleAlertsPanel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    id: DETECTION_RESPONSE_RULE_ALERTS_QUERY_ID,
    title: i18n.RULE_ALERTS_SECTION_TITLE,
    titleSize: "s",
    toggleStatus: toggleStatus,
    toggleQuery: setToggleStatus,
    subtitle: /*#__PURE__*/_react.default.createElement(_last_updated_at.LastUpdatedAt, {
      updatedAt: updatedAt,
      isUpdating: isLoading,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 21
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 9
    }
  }), toggleStatus && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    "data-test-subj": "severityRuleAlertsTable",
    columns: columns,
    items: items,
    loading: isLoading,
    noItemsMessage: /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      title: /*#__PURE__*/_react.default.createElement("h3", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 193,
          columnNumber: 40
        }
      }, i18n.NO_ALERTS_FOUND),
      titleSize: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "severityRuleAlertsButton",
    onClick: navigateToAlerts,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 13
    }
  }, i18n.OPEN_ALL_ALERTS_BUTTON))));
});
RuleAlertsTable.displayName = 'RuleAlertsTable';