"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.AIConnectorCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _centered_loading_spinner = require("../../../../../../common/components/centered_loading_spinner");
var _kibana_react = require("../../../../../../common/lib/kibana/kibana_react");
var i18n = _interopRequireWildcard(require("./translations"));
var _card_content_panel = require("../../common/card_content_panel");
var _connector_cards = require("../../common/connectors/connector_cards");
var _card_subdued_text = require("../../common/card_subdued_text");
var _missing_privileges = require("../../common/connectors/missing_privileges");
var _use_stored_state = require("../../../../../../common/lib/integrations/hooks/use_stored_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/onboarding/components/onboarding_body/cards/siem_migrations/ai_connector/ai_connector_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LlmPerformanceMatrixDocsLink = /*#__PURE__*/_react.default.memo(({
  text
}) => {
  const {
    llmPerformanceMatrix
  } = (0, _kibana_react.useKibana)().services.docLinks.links.securitySolution;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: llmPerformanceMatrix,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  }, text);
});
LlmPerformanceMatrixDocsLink.displayName = 'LlmPerformanceMatrixDocsLink';
const SiemMigrationDocsLink = /*#__PURE__*/_react.default.memo(({
  text
}) => {
  const {
    siemMigrations
  } = (0, _kibana_react.useKibana)().services.docLinks.links.securitySolution;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: siemMigrations,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, text);
});
SiemMigrationDocsLink.displayName = 'SiemMigrationDocsLink';
const AIConnectorCard = ({
  checkCompleteMetadata,
  checkComplete,
  setComplete
}) => {
  const {
    siemMigrations
  } = (0, _kibana_react.useKibana)().services;
  const [storedConnectorId, setStoredConnectorId] = (0, _use_stored_state.useDefinedLocalStorage)(siemMigrations.rules.connectorIdStorage.key, undefined);
  const setSelectedConnector = (0, _react.useCallback)(connector => {
    setStoredConnectorId(connector.id);
    setComplete(true);
    siemMigrations.rules.telemetry.reportConnectorSelected({
      connector
    });
  }, [setComplete, setStoredConnectorId, siemMigrations]);
  const isInferenceConnector = (0, _react.useMemo)(() => {
    var _checkCompleteMetadat, _ref;
    if (!(checkCompleteMetadata !== null && checkCompleteMetadata !== void 0 && (_checkCompleteMetadat = checkCompleteMetadata.connectors) !== null && _checkCompleteMetadat !== void 0 && _checkCompleteMetadat.length) || !storedConnectorId) {
      return false;
    }
    const connector = checkCompleteMetadata.connectors.find(c => c.id === storedConnectorId);
    return (_ref = (connector === null || connector === void 0 ? void 0 : connector.actionTypeId) === '.inference') !== null && _ref !== void 0 ? _ref : false;
  }, [checkCompleteMetadata, storedConnectorId]);
  if (!checkCompleteMetadata) {
    return /*#__PURE__*/_react.default.createElement(_card_content_panel.OnboardingCardContentPanel, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_centered_loading_spinner.CenteredLoadingSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 9
      }
    }));
  }
  const {
    connectors,
    canExecuteConnectors,
    canCreateConnectors
  } = checkCompleteMetadata;
  return /*#__PURE__*/_react.default.createElement(_card_content_panel.OnboardingCardContentPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  }, canExecuteConnectors ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_card_subdued_text.CardSubduedText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  }, i18n.AI_CONNECTOR_CARD_DESCRIPTION_START, isInferenceConnector ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.onboarding.aiConnectorCardInferenceDescription",
    defaultMessage: "The Elastic-provided connector is selected by default. You can configure another connector and model if you prefer. Learn more about {docsLink} and {llmMatrixLink}",
    values: {
      llmMatrixLink: /*#__PURE__*/_react.default.createElement(LlmPerformanceMatrixDocsLink, {
        text: i18n.LLM_MATRIX_LINK,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 36
        }
      }),
      docsLink: /*#__PURE__*/_react.default.createElement(SiemMigrationDocsLink, {
        text: i18n.AI_POWERED_MIGRATIONS_LINK,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 94,
          columnNumber: 31
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.onboarding.aiConnectorCardNotInferenceDescription",
    defaultMessage: "Refer to the {llmMatrixLink} for information about which models perform best. {docsLink} about AI-powered SIEM migration.",
    values: {
      llmMatrixLink: /*#__PURE__*/_react.default.createElement(LlmPerformanceMatrixDocsLink, {
        text: i18n.LLM_MATRIX_LINK,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 36
        }
      }),
      docsLink: /*#__PURE__*/_react.default.createElement(SiemMigrationDocsLink, {
        text: i18n.LEARN_MORE_LINK,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 31
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_connector_cards.ConnectorCards, {
    canCreateConnectors: canCreateConnectors,
    connectors: connectors,
    onNewConnectorSaved: checkComplete,
    selectedConnectorId: storedConnectorId,
    onConnectorSelected: setSelectedConnector,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 13
    }
  }))) : /*#__PURE__*/_react.default.createElement(_missing_privileges.ConnectorsMissingPrivilegesCallOut, {
    level: "read",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 9
    }
  }));
};

// eslint-disable-next-line import/no-default-export
exports.AIConnectorCard = AIConnectorCard;
var _default = exports.default = AIConnectorCard;