"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.IntegrationsCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _card_content_panel = require("../common/card_content_panel");
var _centered_loading_spinner = require("../../../../../common/components/centered_loading_spinner");
var _integration_tabs_configs = require("./integration_tabs_configs");
var _manage_integrations_callout = require("../common/integrations/callouts/manage_integrations_callout");
var _onboarding_context = require("../../../onboarding_context");
var _hooks = require("../../../../../common/lib/search_ai_lake/hooks");
var _with_available_packages = require("../../../../../common/lib/integrations/components/with_available_packages");
var _security_integrations_grid_tabs = require("../../../../../common/lib/integrations/components/security_integrations_grid_tabs");
var _security_integrations = require("../../../../../common/lib/integrations/components/security_integrations");
var _integration_context = require("../../../../../common/lib/integrations/hooks/integration_context");
var _constants = require("../../../../../../common/constants");
var _use_selected_tab = require("../../../../../common/lib/integrations/hooks/use_selected_tab");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/onboarding/components/onboarding_body/cards/integrations_external_detections/integrations_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const IntegrationsCardGridTabs = (0, _with_available_packages.withAvailablePackages)(({
  availablePackages,
  checkCompleteMetadata = _security_integrations.DEFAULT_CHECK_COMPLETE_METADATA
}) => {
  const {
    activeIntegrations,
    isAgentRequired
  } = checkCompleteMetadata;
  const {
    selectedTab
  } = (0, _use_selected_tab.useSelectedTab)();
  const allowedIntegrations = (0, _react.useMemo)(() => availablePackages.filteredCards.filter(card => {
    var _selectedTab$featured, _selectedTab$featured2;
    return (_selectedTab$featured = selectedTab === null || selectedTab === void 0 ? void 0 : (_selectedTab$featured2 = selectedTab.featuredCardIds) === null || _selectedTab$featured2 === void 0 ? void 0 : _selectedTab$featured2.includes(card.id)) !== null && _selectedTab$featured !== void 0 ? _selectedTab$featured : true;
  }), [availablePackages.filteredCards, selectedTab]);
  const {
    available: list
  } = (0, _hooks.useEnhancedIntegrationCards)(allowedIntegrations, activeIntegrations, {
    showInstallationStatus: true,
    showCompressedInstallationStatus: true,
    returnPath: _constants.ONBOARDING_PATH
  });
  const activeIntegrationsCount = activeIntegrations.length;
  return /*#__PURE__*/_react.default.createElement(_security_integrations_grid_tabs.SecurityIntegrationsGridTabs, {
    isAgentRequired: isAgentRequired,
    activeIntegrationsCount: activeIntegrationsCount,
    topCalloutRenderer: activeIntegrationsCount ? _manage_integrations_callout.ManageIntegrationsCallout : undefined,
    integrationList: list,
    availablePackages: availablePackages,
    packageListGridOptions: {
      showCardLabels: true
    },
    selectedTab: selectedTab,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  });
});
const IntegrationsCard = exports.IntegrationsCard = /*#__PURE__*/_react.default.memo(({
  checkCompleteMetadata
}) => {
  const {
    spaceId,
    telemetry: {
      reportLinkClick
    }
  } = (0, _onboarding_context.useOnboardingContext)();
  const checkExternalIntegrationsCompleteMetaData = (0, _react.useMemo)(() => {
    var _checkCompleteMetadat;
    return {
      activeIntegrations: (_checkCompleteMetadat = checkCompleteMetadata === null || checkCompleteMetadata === void 0 ? void 0 : checkCompleteMetadata.activeIntegrations) !== null && _checkCompleteMetadat !== void 0 ? _checkCompleteMetadat : [],
      // There are a few agentless integrations featured, so we don't show the agent required callout.
      isAgentRequired: false
    };
  }, [checkCompleteMetadata === null || checkCompleteMetadata === void 0 ? void 0 : checkCompleteMetadata.activeIntegrations]);
  if (!checkCompleteMetadata) {
    return /*#__PURE__*/_react.default.createElement(_centered_loading_spinner.CenteredLoadingSpinner, {
      "data-test-subj": "loadingInstalledIntegrations",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 14
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_card_content_panel.OnboardingCardContentPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_integration_context.IntegrationContextProvider, {
    spaceId: spaceId,
    reportLinkClick: reportLinkClick,
    integrationTabs: _integration_tabs_configs.INTEGRATION_TABS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(IntegrationsCardGridTabs, {
    prereleaseIntegrationsEnabled: true,
    checkCompleteMetadata: checkExternalIntegrationsCompleteMetaData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 11
    }
  })));
});
IntegrationsCard.displayName = 'IntegrationsCard';

// eslint-disable-next-line import/no-default-export
var _default = exports.default = IntegrationsCard;