"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DASHBOARDS_CARD_ITEMS_BY_ID = exports.DASHBOARDS_CARD_ITEMS = void 0;
var _i18n = require("@kbn/i18n");
var _types = require("./types");
var _types2 = require("../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DASHBOARDS_CARD_ITEMS = exports.DASHBOARDS_CARD_ITEMS = [{
  id: _types.DashboardsCardItemId.default,
  title: _i18n.i18n.translate('xpack.securitySolution.onboarding.dashboardsCard.default.title', {
    defaultMessage: 'Use Elastic’s default dashboards'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.onboarding.dashboardsCard.default.description', {
    defaultMessage: 'Out-of-the-box dashboards for alerts, data quality, entity analytics, and more'
  }),
  asset: {
    type: _types2.CardAssetType.video,
    source: '//play.vidyard.com/SpKecbJxeYWzXVpGvgxMah',
    alt: _i18n.i18n.translate('xpack.securitySolution.onboarding.dashboardsCard.default.description', {
      defaultMessage: 'Out-of-the-box dashboards for alerts, data quality, entity analytics, and more'
    })
  }
}, {
  id: _types.DashboardsCardItemId.custom,
  title: _i18n.i18n.translate('xpack.securitySolution.onboarding.dashboardsCard.custom.title', {
    defaultMessage: 'Create a dashboard'
  }),
  description: _i18n.i18n.translate('xpack.securitySolution.onboarding.dashboardsCard.custom.description', {
    defaultMessage: 'Drag and drop your way to a custom visualization'
  }),
  asset: {
    type: _types2.CardAssetType.video,
    source: '//play.vidyard.com/5UvJBpzFVoEfpDLnjzTbfn',
    alt: _i18n.i18n.translate('xpack.securitySolution.onboarding.dashboardsCard.custom.description', {
      defaultMessage: 'Drag and drop your way to a custom visualization'
    })
  }
}];
const DASHBOARDS_CARD_ITEMS_BY_ID = exports.DASHBOARDS_CARD_ITEMS_BY_ID = Object.fromEntries(DASHBOARDS_CARD_ITEMS.map(card => [card.id, card]));