"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MARKDOWN_ARIA_LABEL = exports.CREATE_NOTE_ERROR = exports.AddNote = exports.ADD_NOTE_BUTTON = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../common/lib/kibana");
var _test_ids = require("./test_ids");
var _use_app_toasts = require("../../common/hooks/use_app_toasts");
var _notes = require("../store/notes.slice");
var _markdown_editor = require("../../common/components/markdown_editor");
var _telemetry = require("../../common/lib/telemetry");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/notes/components/add_note.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MARKDOWN_ARIA_LABEL = exports.MARKDOWN_ARIA_LABEL = _i18n.i18n.translate('xpack.securitySolution.notes.addNote.markdownAriaLabel', {
  defaultMessage: 'Note'
});
const ADD_NOTE_BUTTON = exports.ADD_NOTE_BUTTON = _i18n.i18n.translate('xpack.securitySolution.notes.addNote.buttonLabel', {
  defaultMessage: 'Add note'
});
const CREATE_NOTE_ERROR = exports.CREATE_NOTE_ERROR = _i18n.i18n.translate('xpack.securitySolution.notes.createNote.errorLabel', {
  defaultMessage: 'Error create note'
});
/**
 * Renders a markdown editor and an add button to create new notes.
 * The checkbox is automatically checked if the flyout is opened from a timeline and that timeline is saved. It is disabled if the flyout is NOT opened from a timeline.
 */
const AddNote = exports.AddNote = /*#__PURE__*/(0, _react.memo)(({
  eventId,
  timelineId,
  disableButton = false,
  children,
  onNoteAdd
}) => {
  const {
    telemetry
  } = (0, _kibana.useKibana)().services;
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    addError: addErrorToast
  } = (0, _use_app_toasts.useAppToasts)();
  const [editorValue, setEditorValue] = (0, _react.useState)('');
  const [isMarkdownInvalid, setIsMarkdownInvalid] = (0, _react.useState)(false);
  const createStatus = (0, _reactRedux.useSelector)(state => (0, _notes.selectCreateNoteStatus)(state));
  const createError = (0, _reactRedux.useSelector)(state => (0, _notes.selectCreateNoteError)(state));
  const addNote = (0, _react.useCallback)(() => {
    dispatch((0, _notes.createNote)({
      note: {
        timelineId: timelineId || '',
        eventId: eventId || '',
        note: editorValue
      }
    }));
    if (onNoteAdd) {
      onNoteAdd();
    }
    telemetry.reportEvent(_telemetry.NotesEventTypes.AddNoteFromExpandableFlyoutClicked, {
      isRelatedToATimeline: timelineId != null
    });
    setEditorValue('');
  }, [dispatch, editorValue, eventId, telemetry, timelineId, onNoteAdd]);
  const resetError = (0, _react.useCallback)(() => {
    dispatch((0, _notes.userClosedCreateErrorToast)());
  }, [dispatch]);

  // show a toast if the create note call fails
  (0, _react.useEffect)(() => {
    if (createStatus === _notes.ReqStatus.Failed && createError) {
      addErrorToast(createError, {
        title: CREATE_NOTE_ERROR
      });
      resetError();
    }
  }, [addErrorToast, createError, createStatus, resetError]);
  const buttonDisabled = (0, _react.useMemo)(() => disableButton || editorValue.trim().length === 0 || isMarkdownInvalid, [disableButton, editorValue, isMarkdownInvalid]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCommentList, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComment, {
    username: "",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_markdown_editor.MarkdownEditor, {
    dataTestSubj: _test_ids.ADD_NOTE_MARKDOWN_TEST_ID,
    value: editorValue,
    onChange: setEditorValue,
    ariaLabel: MARKDOWN_ARIA_LABEL,
    setIsMarkdownInvalid: setIsMarkdownInvalid,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 9
    }
  }), children && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexEnd",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: addNote,
    isLoading: createStatus === _notes.ReqStatus.Loading,
    disabled: buttonDisabled,
    "data-test-subj": _test_ids.ADD_NOTE_BUTTON_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 13
    }
  }, ADD_NOTE_BUTTON))));
});
AddNote.displayName = 'AddNote';