"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeviceControlCard = exports.DEVICE_CONTROL_CARD_TITLE = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _use_test_id_generator = require("../../../../../../hooks/use_test_id_generator");
var _use_license = require("../../../../../../../common/hooks/use_license");
var _setting_locked_card = require("../setting_locked_card");
var _setting_card = require("../setting_card");
var _device_control_setting_card_switch = require("../device_control_setting_card_switch");
var _device_control_protection_level = require("../device_control_protection_level");
var _device_control_notify_user_option = require("../device_control_notify_user_option");
var _types = require("../../../../../../../../common/endpoint/types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/policy_settings_form/components/cards/device_control_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DEVICE_CONTROL_CARD_TITLE = exports.DEVICE_CONTROL_CARD_TITLE = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.deviceControl', {
  defaultMessage: 'Device Control'
});
const DEVICE_CONTROL_OS_VALUES = [_types.PolicyOperatingSystem.windows, _types.PolicyOperatingSystem.mac];
const DeviceControlCard = exports.DeviceControlCard = /*#__PURE__*/_react.default.memo(({
  policy,
  onChange,
  mode = 'edit',
  'data-test-subj': dataTestSubj
}) => {
  var _policy$windows$devic, _policy$mac$device_co;
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const isEnterprise = (0, _use_license.useLicense)().isEnterprise();

  // Check if device_control exists in policy (backward compatibility)
  const deviceControlExists = policy.windows.device_control !== undefined && policy.mac.device_control !== undefined;
  const selected = Boolean(deviceControlExists && (((_policy$windows$devic = policy.windows.device_control) === null || _policy$windows$devic === void 0 ? void 0 : _policy$windows$devic.enabled) || ((_policy$mac$device_co = policy.mac.device_control) === null || _policy$mac$device_co === void 0 ? void 0 : _policy$mac$device_co.enabled)));
  const protectionLabel = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.protections.deviceControl', {
    defaultMessage: 'Device Control'
  });
  if (!isEnterprise) {
    return /*#__PURE__*/_react.default.createElement(_setting_locked_card.SettingLockedCard, {
      title: DEVICE_CONTROL_CARD_TITLE,
      licenseType: "enterprise",
      "data-test-subj": getTestId('locked'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 9
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_setting_card.SettingCard, {
    type: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.deviceControl', {
      defaultMessage: 'Device Control'
    }),
    supportedOss: [_securitysolutionUtils.OperatingSystem.WINDOWS, _securitysolutionUtils.OperatingSystem.MAC],
    dataTestSubj: getTestId(),
    selected: selected,
    mode: mode,
    rightCorner: /*#__PURE__*/_react.default.createElement(_device_control_setting_card_switch.DeviceControlSettingCardSwitch, {
      selected: selected,
      policy: policy,
      onChange: onChange,
      mode: mode,
      protectionLabel: protectionLabel,
      osList: DEVICE_CONTROL_OS_VALUES,
      "data-test-subj": getTestId('enableDisableSwitch'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_device_control_protection_level.DeviceControlProtectionLevel, {
    osList: DEVICE_CONTROL_OS_VALUES,
    onChange: onChange,
    policy: policy,
    mode: mode,
    "data-test-subj": getTestId('protectionLevel'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_device_control_notify_user_option.DeviceControlNotifyUserOption, {
    onChange: onChange,
    policy: policy,
    mode: mode,
    "data-test-subj": getTestId('notifyUser'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 9
    }
  }));
});
DeviceControlCard.displayName = 'DeviceControlCard';