"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointGenericErrorsList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _kibana = require("../../../../../common/lib/kibana");
var _package_action_formatter = require("../../../../components/package_action_item/package_action_formatter");
var _package_action_item_error = require("../../../../components/package_action_item/package_action_item_error");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/ingest_manager_integration/endpoint_generic_errors_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Exports Endpoint-generic errors list
 */
const EndpointGenericErrorsList = exports.EndpointGenericErrorsList = /*#__PURE__*/(0, _react.memo)(({
  packageErrors
}) => {
  const {
    docLinks
  } = (0, _kibana.useKibana)().services;
  const globalEndpointErrors = (0, _react.useMemo)(() => {
    const errors = [];
    packageErrors.forEach(unit => {
      if (unit.status === 'FAILED' || unit.status === 'DEGRADED') {
        errors.push(new _package_action_formatter.PackageActionFormatter(unit, docLinks.links.securitySolution.packageActionTroubleshooting));
      }
    });
    return errors;
  }, [packageErrors, docLinks.links.securitySolution.packageActionTroubleshooting]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, globalEndpointErrors.map(error => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
    key: error.key,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_package_action_item_error.PackageActionItemError, {
    actionFormatter: error,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 13
    }
  }))));
});
EndpointGenericErrorsList.displayName = 'EndpointGenericErrorsList';