"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentsSummary = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _styledComponents = require("styled-components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/policy/view/components/agents_summary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Display a summary of stats (counts) associated with a group of agents (ex. those associated with a Policy)
 */
const AgentsSummary = exports.AgentsSummary = /*#__PURE__*/(0, _react.memo)(props => {
  const stats = (0, _react.useMemo)(() => {
    return [{
      key: 'total',
      title: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetails.agentsSummary.totalTitle', {
        defaultMessage: 'Total agents'
      }),
      health: ''
    }, {
      key: 'online',
      title: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetails.agentsSummary.onlineTitle', {
        defaultMessage: 'Healthy'
      }),
      health: 'success'
    }, {
      key: 'error',
      title: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetails.agentsSummary.errorTitle', {
        defaultMessage: 'Unhealthy'
      }),
      health: 'warning'
    }, {
      key: 'offline',
      title: _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetails.agentsSummary.offlineTitle', {
        defaultMessage: 'Offline'
      }),
      health: 'subdued'
    }];
  }, []);
  const theme = (0, _react.useContext)(_styledComponents.ThemeContext);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    responsive: false,
    "data-test-subj": "policyAgentsSummary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 5
    }
  }, stats.map(({
    key,
    title,
    health
  }) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: key,
      style: {
        marginRight: key === 'total' ? theme.eui.euiSizeXXL : undefined
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      textStyle: "reverse",
      css: {
        textAlign: 'right'
      },
      listItems: [{
        title,
        description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, health && /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
          color: health === 'warning' ? theme.eui.euiColorWarning : health,
          className: "eui-alignMiddle",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 99,
            columnNumber: 25
          }
        }), /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
          value: props[key],
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 104,
            columnNumber: 23
          }
        }))
      }],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 13
      }
    }));
  }));
});
AgentsSummary.displayName = 'AgentsSummary';