"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableRowActions = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _context_menu_item_nav_by_router = require("../../../../components/context_menu_with_router_support/context_menu_item_nav_by_router");
var _hooks = require("../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/pages/endpoint_hosts/view/components/table_row_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TableRowActions = exports.TableRowActions = /*#__PURE__*/(0, _react.memo)(({
  endpointInfo
}) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const endpointActions = (0, _hooks.useEndpointActionItems)(endpointInfo, {
    isEndpointList: true
  });
  const handleCloseMenu = (0, _react.useCallback)(() => setIsOpen(false), [setIsOpen]);
  const handleToggleMenu = (0, _react.useCallback)(() => setIsOpen(!isOpen), [isOpen]);
  const menuItems = (0, _react.useMemo)(() => {
    return endpointActions.map(itemProps => {
      return /*#__PURE__*/_react.default.createElement(_context_menu_item_nav_by_router.ContextMenuItemNavByRouter, (0, _extends2.default)({}, itemProps, {
        onClick: ev => {
          handleCloseMenu();
          if (itemProps.onClick) {
            itemProps.onClick(ev);
          }
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 30,
          columnNumber: 9
        }
      }));
    });
  }, [handleCloseMenu, endpointActions]);
  const panelProps = (0, _react.useMemo)(() => {
    return {
      'data-test-subj': 'tableRowActionsMenuPanel'
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downRight",
    panelPaddingSize: "none",
    panelProps: panelProps,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "endpointTableRowActions",
      iconType: "boxesHorizontal",
      onClick: handleToggleMenu,
      "aria-label": _i18n.i18n.translate('xpack.securitySolution.endpoint.list.actionmenu', {
        defaultMessage: 'Open'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 9
      }
    }),
    isOpen: isOpen,
    closePopover: handleCloseMenu,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: menuItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }));
});
TableRowActions.displayName = 'EndpointTableRowActions';