"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GridHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _artifact_entry_card = require("../../artifact_entry_card");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/management/components/artifact_card_grid/components/grid_header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GridHeaderContainer = (0, _styledComponents.default)(_artifact_entry_card.CardSectionPanel)`
  padding-top: 0;
  padding-bottom: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const GridHeader = exports.GridHeader = /*#__PURE__*/(0, _react.memo)(({
  'data-test-subj': dataTestSubj,
  expandAllIconType,
  onExpandCollapseAll
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const expandToggleElement = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": getTestId('expandCollapseAllButton'),
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.artifactCardGrid.expandCollapseLabel', {
      defaultMessage: '{action} all cards',
      values: {
        action: 'unfold' ? 'Expand' : 'Collapse'
      }
    }),
    iconType: expandAllIconType,
    onClick: () => onExpandCollapseAll(),
    css: {
      marginLeft: '-5px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 9
    }
  }), [getTestId, expandAllIconType, onExpandCollapseAll]);
  return /*#__PURE__*/_react.default.createElement(GridHeaderContainer, {
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_artifact_entry_card.CardCompressedHeaderLayout, {
    expanded: false,
    expandToggle: expandToggleElement,
    "data-test-subj": getTestId('layout'),
    flushTop: true,
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      "data-test-subj": getTestId('name'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.artifactCardGrid.nameColumn",
      defaultMessage: "Name",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 17
      }
    }))),
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      "data-test-subj": getTestId('description'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.artifactCardGrid.DescriptionColumn",
      defaultMessage: "Description",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 17
      }
    }))),
    effectScope: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      "data-test-subj": getTestId('assignment'),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.artifactCardGrid.assignmentColumn",
      defaultMessage: "Assignment",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 17
      }
    }))),
    actionMenu: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }));
});
GridHeader.displayName = 'GridHeader';