"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomaliesField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _anomaly_scores = require("../../../../common/components/ml/score/anomaly_scores");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _score_interval_to_datetime = require("../../../../common/components/ml/score/score_interval_to_datetime");
var _constants = require("../../../../common/store/inputs/constants");
var _actions = require("../../../../common/store/inputs/actions");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/entity_details/shared/components/anomalies_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AnomaliesField = ({
  anomalies
}) => {
  const {
    to,
    from
  } = (0, _use_global_time.useGlobalTime)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const narrowDateRange = (0, _react.useCallback)((score, interval) => {
    const fromTo = (0, _score_interval_to_datetime.scoreIntervalToDateTime)(score, interval);
    dispatch((0, _actions.setAbsoluteRangeDatePicker)({
      id: _constants.InputsModelId.global,
      from: fromTo.from,
      to: fromTo.to
    }));
  }, [dispatch]);
  return /*#__PURE__*/_react.default.createElement(_anomaly_scores.AnomalyScores, {
    anomalies: anomalies.anomalies,
    startDate: from,
    endDate: to,
    isLoading: anomalies.isLoading,
    narrowDateRange: narrowDateRange,
    jobNameById: anomalies.jobNameById,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  });
};
exports.AnomaliesField = AnomaliesField;