"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAnomaliesFields = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _has_ml_user_permissions = require("../../../../common/machine_learning/has_ml_user_permissions");
var _empty_value = require("../../../common/components/empty_value");
var _anomalies_field = require("./components/anomalies_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/entity_details/shared/common.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getAnomaliesFields = mlCapabilities => [{
  label: _i18n.i18n.translate('xpack.securitySolution.timeline.sidePanel.maxAnomalyScoreByJobTitle', {
    defaultMessage: 'Max anomaly score by job'
  }),
  render: hostData => hostData.anomalies ? /*#__PURE__*/_react.default.createElement(_anomalies_field.AnomaliesField, {
    anomalies: hostData.anomalies,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 28
    }
  }) : (0, _empty_value.getEmptyTagValue)(),
  isVisible: () => (0, _has_ml_user_permissions.hasMlUserPermissions)(mlCapabilities)
}];
exports.getAnomaliesFields = getAnomaliesFields;