"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServicePanelContent = exports.OBSERVED_SERVICE_QUERY_ID = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _asset_criticality_selector = require("../../../entity_analytics/components/asset_criticality/asset_criticality_selector");
var _risk_summary = require("../../../entity_analytics/components/risk_summary_flyout/risk_summary");
var _types = require("../../../../common/entity_analytics/types");
var _ = require(".");
var _flyout_body = require("../../shared/components/flyout_body");
var _observed_entity = require("../shared/components/observed_entity");
var _use_observed_service_items = require("./hooks/use_observed_service_items");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/entity_details/service_right/content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const OBSERVED_SERVICE_QUERY_ID = exports.OBSERVED_SERVICE_QUERY_ID = 'observedServiceDetailsQuery';
const ServicePanelContent = ({
  serviceName,
  observedService,
  riskScoreState,
  recalculatingScore,
  contextID,
  scopeId,
  openDetailsPanel,
  onAssetCriticalityChange,
  isPreviewMode,
  isLinkEnabled
}) => {
  var _riskScoreState$data;
  const observedFields = (0, _use_observed_service_items.useObservedServiceItems)(observedService);
  return /*#__PURE__*/_react.default.createElement(_flyout_body.FlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  }, riskScoreState.hasEngineBeenInstalled && ((_riskScoreState$data = riskScoreState.data) === null || _riskScoreState$data === void 0 ? void 0 : _riskScoreState$data.length) !== 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_risk_summary.FlyoutRiskSummary, {
    riskScoreData: riskScoreState,
    recalculatingScore: recalculatingScore,
    queryId: _.SERVICE_PANEL_RISK_SCORE_QUERY_ID,
    openDetailsPanel: openDetailsPanel,
    isPreviewMode: isPreviewMode,
    isLinkEnabled: isLinkEnabled,
    entityType: _types.EntityType.service,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_asset_criticality_selector.AssetCriticalityAccordion, {
    entity: {
      name: serviceName,
      type: _types.EntityType.service
    },
    onChange: onAssetCriticalityChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_observed_entity.ObservedEntity, {
    observedData: observedService,
    contextID: contextID,
    scopeId: scopeId,
    observedFields: observedFields,
    queryId: OBSERVED_SERVICE_QUERY_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }));
};
exports.ServicePanelContent = ServicePanelContent;