"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizationsSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _use_expand_section = require("../hooks/use_expand_section");
var _analyzer_preview_container = require("./analyzer_preview_container");
var _session_preview_container = require("./session_preview_container");
var _expandable_section = require("./expandable_section");
var _test_ids = require("./test_ids");
var _graph_preview_container = require("./graph_preview_container");
var _context = require("../../shared/context");
var _use_graph_preview = require("../../shared/hooks/use_graph_preview");
var _constants = require("../../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/right/components/visualizations_section.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const KEY = 'visualizations';

/**
 * Visualizations section in overview. It contains analyzer preview and session view preview.
 */
const VisualizationsSection = exports.VisualizationsSection = /*#__PURE__*/(0, _react.memo)(() => {
  const expanded = (0, _use_expand_section.useExpandSection)({
    title: KEY,
    defaultValue: false
  });
  const {
    dataAsNestedObject,
    getFieldsData,
    dataFormattedForFieldBrowser
  } = (0, _context.useDocumentDetailsContext)();
  const [graphVisualizationEnabled] = (0, _public.useUiSetting$)(_constants.ENABLE_GRAPH_VISUALIZATION_SETTING);

  // Decide whether to show the graph preview or not
  const {
    hasGraphRepresentation
  } = (0, _use_graph_preview.useGraphPreview)({
    getFieldsData,
    ecsData: dataAsNestedObject,
    dataFormattedForFieldBrowser
  });
  const shouldShowGraphPreview = (0, _react.useMemo)(() => graphVisualizationEnabled && hasGraphRepresentation, [graphVisualizationEnabled, hasGraphRepresentation]);
  return /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSection, {
    expanded: expanded,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.right.visualizations.sectionTitle",
      defaultMessage: "Visualizations",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 9
      }
    }),
    localStorageKey: KEY,
    "data-test-subj": _test_ids.VISUALIZATIONS_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_session_preview_container.SessionPreviewContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_analyzer_preview_container.AnalyzerPreviewContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }), shouldShowGraphPreview && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_graph_preview_container.GraphPreviewContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 11
    }
  })));
});
VisualizationsSection.displayName = 'VisualizationsSection';