"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelatedCases = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _cell_tooltip_wrapper = require("../../shared/components/cell_tooltip_wrapper");
var _links = require("../../../../common/components/links");
var _test_ids = require("./test_ids");
var _use_fetch_related_cases = require("../../shared/hooks/use_fetch_related_cases");
var _expandable_panel = require("../../../shared/components/expandable_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/flyout/document_details/left/components/related_cases.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ICON = 'warning';
const EXPAND_PROPERTIES = {
  expandable: true,
  expandedOnFirstRender: true
};
const getColumns = data => [{
  field: 'title',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.correlations.nameColumnLabel",
    defaultMessage: "Name",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 7
    }
  }),
  render: (_, caseData) => /*#__PURE__*/_react.default.createElement(_cell_tooltip_wrapper.CellTooltipWrapper, {
    tooltip: caseData.title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_links.CaseDetailsLink, {
    detailName: caseData.id,
    title: caseData.title,
    openInNewTab: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 9
    }
  }, caseData.title, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: 'popout',
    size: "m",
    color: "primary",
    css: (0, _react2.css)`
              margin-left: 4px;
            `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 11
    }
  })))
}, {
  field: 'status',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.correlations.statusColumnLabel",
    defaultMessage: "Status",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }),
  truncateText: true,
  width: '25%'
}];
/**
 * Show related cases in an expandable panel with a table
 */
const RelatedCases = ({
  eventId
}) => {
  const {
    loading,
    error,
    data,
    dataCount
  } = (0, _use_fetch_related_cases.useFetchRelatedCases)({
    eventId
  });
  const columns = (0, _react.useMemo)(() => getColumns(data), [data]);
  const title = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.insights.correlations.relatedCasesTitle",
    defaultMessage: "{count} related {count, plural, one {case} other {cases}}",
    values: {
      count: dataCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }), [dataCount]);
  const header = (0, _react.useMemo)(() => ({
    title,
    iconType: ICON
  }), [title]);
  if (error) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_expandable_panel.ExpandablePanel, {
    header: header,
    expand: EXPAND_PROPERTIES,
    "data-test-subj": _test_ids.CORRELATIONS_DETAILS_CASES_SECTION_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    loading: loading,
    items: data,
    columns: columns,
    pagination: true,
    message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.left.insights.correlations.relatedCasesNoDataDescription",
      defaultMessage: "No related cases.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 11
      }
    }),
    "data-test-subj": _test_ids.CORRELATIONS_DETAILS_CASES_SECTION_TABLE_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }));
};
exports.RelatedCases = RelatedCases;
RelatedCases.displayName = 'RelatedCases';