"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UsersDetails = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _common = require("@kbn/data-plugin/common");
var _esQuery = require("@kbn/es-query");
var _common2 = require("@kbn/timelines-plugin/common");
var _constants = require("../../../../data_view_manager/constants");
var _model = require("../../../../sourcerer/store/model");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _kuery = require("../../../../common/lib/kuery");
var _use_calculate_entity_risk_score = require("../../../../entity_analytics/api/hooks/use_calculate_entity_risk_score");
var _use_asset_criticality = require("../../../../entity_analytics/components/asset_criticality/use_asset_criticality");
var _asset_criticality_selector = require("../../../../entity_analytics/components/asset_criticality/asset_criticality_selector");
var _alerts_by_status = require("../../../../overview/components/detection_response/alerts_by_status");
var _use_signal_index = require("../../../../detections/containers/detection_engine/alerts/use_signal_index");
var _alert_count_by_status = require("../../../../common/components/alert_count_by_status");
var _constants2 = require("../../../../common/store/inputs/constants");
var _types = require("../../../../app/types");
var _filters_global = require("../../../../common/components/filters_global");
var _header_page = require("../../../../common/components/header_page");
var _tab_navigation = require("../../../../common/components/navigation/tab_navigation");
var _search_bar = require("../../../../common/components/search_bar");
var _page_wrapper = require("../../../../common/components/page_wrapper");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _kibana = require("../../../../common/lib/kibana");
var _store = require("../../../../common/store");
var _use_alerts_privileges = require("../../../../detections/containers/detection_engine/alerts/use_alerts_privileges");
var _actions = require("../../store/actions");
var _actions2 = require("../../../../common/store/inputs/actions");
var _spy_routes = require("../../../../common/utils/route/spy_routes");
var _details_tabs = require("./details_tabs");
var _nav_tabs = require("./nav_tabs");
var _helpers = require("./helpers");
var _use_full_screen = require("../../../../common/containers/use_full_screen");
var _containers = require("../../../../sourcerer/containers");
var _use_selector = require("../../../../common/hooks/use_selector");
var _use_invalid_filter_query = require("../../../../common/hooks/use_invalid_filter_query");
var _last_event_time = require("../../../../common/components/last_event_time");
var _types2 = require("../../../../../common/entity_analytics/types");
var _anomaly_table_provider = require("../../../../common/components/ml/anomaly/anomaly_table_provider");
var _user_overview = require("../../../../overview/components/user_overview");
var _observed_details = require("../../containers/users/observed_details");
var _manage_query = require("../../../../common/components/page/manage_query");
var _score_interval_to_datetime = require("../../../../common/components/ml/score/score_interval_to_datetime");
var _get_criteria_from_users_type = require("../../../../common/components/ml/criteria/get_criteria_from_users_type");
var _model2 = require("../../store/model");
var _has_ml_user_permissions = require("../../../../../common/machine_learning/has_ml_user_permissions");
var _use_ml_capabilities = require("../../../../common/components/ml/hooks/use_ml_capabilities");
var _empty_prompt = require("../../../../common/components/empty_prompt");
var _use_refetch_overview_page_risk_score = require("../../../../entity_analytics/api/hooks/use_refetch_overview_page_risk_score");
var _use_data_view = require("../../../../data_view_manager/hooks/use_data_view");
var _use_selected_patterns = require("../../../../data_view_manager/hooks/use_selected_patterns");
var _page_loader = require("../../../../common/components/page_loader");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/users/pages/details/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const QUERY_ID = 'UsersDetailsQueryId';
const ES_USER_FIELD = 'user.name';
const UsersDetailsComponent = ({
  detailName,
  usersDetailsPagePath
}) => {
  var _privileges$data;
  const dispatch = (0, _reactRedux.useDispatch)();
  const getGlobalFiltersQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalFiltersQuerySelector(), []);
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalQuerySelector(), []);
  const query = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const globalFilters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersQuerySelector);
  const {
    signalIndexName
  } = (0, _use_signal_index.useSignalIndex)();
  const {
    hasKibanaREAD,
    hasIndexRead
  } = (0, _use_alerts_privileges.useAlertsPrivileges)();
  const canReadAlerts = hasKibanaREAD && hasIndexRead;
  const {
    to,
    from,
    deleteQuery,
    setQuery,
    isInitializing
  } = (0, _use_global_time.useGlobalTime)();
  const {
    globalFullScreen
  } = (0, _use_full_screen.useGlobalFullScreen)();
  const {
    services: {
      uiSettings
    }
  } = (0, _kibana.useKibana)();
  const usersDetailsPageFilters = (0, _react.useMemo)(() => (0, _helpers.getUsersDetailsPageFilters)(detailName), [detailName]);
  const {
    indicesExist: oldIndicesExist,
    selectedPatterns: oldSelectedPatterns,
    sourcererDataView: oldSourcererDataView
  } = (0, _containers.useSourcererDataView)();
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView: experimentalDataView,
    status
  } = (0, _use_data_view.useDataView)(_constants.DataViewManagerScopeName.explore);
  const experimentalSelectedPatterns = (0, _use_selected_patterns.useSelectedPatterns)(_constants.DataViewManagerScopeName.explore);
  const indicesExist = newDataViewPickerEnabled ? experimentalDataView.hasMatchedIndices() : oldIndicesExist;
  const selectedPatterns = newDataViewPickerEnabled ? experimentalSelectedPatterns : oldSelectedPatterns;
  const [rawFilteredQuery, kqlError] = (0, _react.useMemo)(() => {
    try {
      return [(0, _esQuery.buildEsQuery)(newDataViewPickerEnabled ? experimentalDataView : (0, _kuery.dataViewSpecToViewBase)(oldSourcererDataView), [query], [...usersDetailsPageFilters, ...globalFilters], (0, _common.getEsQueryConfig)(uiSettings))];
    } catch (e) {
      return [undefined, e];
    }
  }, [experimentalDataView, globalFilters, newDataViewPickerEnabled, oldSourcererDataView, query, uiSettings, usersDetailsPageFilters]);
  const stringifiedAdditionalFilters = JSON.stringify(rawFilteredQuery);
  (0, _use_invalid_filter_query.useInvalidFilterQuery)({
    id: QUERY_ID,
    filterQuery: stringifiedAdditionalFilters,
    kqlError,
    query,
    startDate: from,
    endDate: to
  });
  (0, _react.useEffect)(() => {
    dispatch((0, _actions.setUsersDetailsTablesActivePageToZero)());
  }, [dispatch, detailName]);
  const [loading, {
    inspect,
    userDetails,
    refetch
  }] = (0, _observed_details.useObservedUserDetails)({
    id: QUERY_ID,
    endDate: to,
    startDate: from,
    userName: detailName,
    indexNames: selectedPatterns,
    skip: selectedPatterns.length === 0
  });
  const capabilities = (0, _use_ml_capabilities.useMlCapabilities)();
  (0, _manage_query.useQueryInspector)({
    setQuery,
    deleteQuery,
    refetch,
    inspect,
    loading,
    queryId: QUERY_ID
  });
  const narrowDateRange = (0, _react.useCallback)((score, interval) => {
    const fromTo = (0, _score_interval_to_datetime.scoreIntervalToDateTime)(score, interval);
    dispatch((0, _actions2.setAbsoluteRangeDatePicker)({
      id: _constants2.InputsModelId.global,
      from: fromTo.from,
      to: fromTo.to
    }));
  }, [dispatch]);
  const entityFilter = (0, _react.useMemo)(() => ({
    field: ES_USER_FIELD,
    value: detailName
  }), [detailName]);
  const entity = (0, _react.useMemo)(() => ({
    type: _types2.EntityType.user,
    name: detailName
  }), [detailName]);
  const privileges = (0, _use_asset_criticality.useAssetCriticalityPrivileges)(entity.name);
  const refetchRiskScore = (0, _use_refetch_overview_page_risk_score.useRefetchOverviewPageRiskScore)(_user_overview.USER_OVERVIEW_RISK_SCORE_QUERY_ID);
  const {
    calculateEntityRiskScore
  } = (0, _use_calculate_entity_risk_score.useCalculateEntityRiskScore)(_types2.EntityType.user, detailName, {
    onSuccess: refetchRiskScore
  });
  const additionalFilters = (0, _react.useMemo)(() => rawFilteredQuery ? [rawFilteredQuery] : [], [rawFilteredQuery]);
  const canReadAssetCriticality = !!((_privileges$data = privileges.data) !== null && _privileges$data !== void 0 && _privileges$data.has_read_permissions);
  const criticality = (0, _use_asset_criticality.useAssetCriticalityData)({
    entity,
    enabled: canReadAssetCriticality,
    onChange: calculateEntityRiskScore
  });
  if (newDataViewPickerEnabled && status === 'pristine') {
    return /*#__PURE__*/_react.default.createElement(_page_loader.PageLoader, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 226,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, indicesExist ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiWindowEvent, {
    event: "resize",
    handler: _fp.noop,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_search_bar.SiemSearchBar, {
    sourcererDataView: newDataViewPickerEnabled ? experimentalDataView : oldSourcererDataView // TODO: newDataViewPicker - Can be removed after migration to new dataview picker
    ,
    id: _constants2.InputsModelId.global,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    noPadding: globalFullScreen,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    subtitle: /*#__PURE__*/_react.default.createElement(_last_event_time.LastEventTime, {
      indexKey: _common2.LastEventIndexKey.userDetails,
      indexNames: selectedPatterns,
      userName: detailName,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 246,
        columnNumber: 17
      }
    }),
    title: detailName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 244,
      columnNumber: 13
    }
  }), canReadAssetCriticality && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_asset_criticality_selector.AssetCriticalityTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_asset_criticality_selector.AssetCriticalitySelector, {
    compressed: true,
    criticality: criticality,
    entity: entity,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_anomaly_table_provider.AnomalyTableProvider, {
    criteriaFields: (0, _get_criteria_from_users_type.getCriteriaFromUsersType)(_model2.UsersType.details, detailName),
    startDate: from,
    endDate: to,
    skip: isInitializing,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 13
    }
  }, ({
    isLoadingAnomaliesData,
    anomaliesData,
    jobNameById
  }) => /*#__PURE__*/_react.default.createElement(_user_overview.UserOverview, {
    userName: detailName,
    id: QUERY_ID,
    isInDetailsSidePanel: false,
    data: userDetails,
    anomaliesData: anomaliesData,
    isLoadingAnomaliesData: isLoadingAnomaliesData,
    loading: loading,
    startDate: from,
    endDate: to,
    narrowDateRange: narrowDateRange,
    indexPatterns: selectedPatterns,
    jobNameById: jobNameById,
    scopeId: newDataViewPickerEnabled ? _model.SourcererScopeName.explore : _model.SourcererScopeName.default,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 13
    }
  }), canReadAlerts && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_alerts_by_status.AlertsByStatus, {
    signalIndexName: signalIndexName,
    entityFilter: entityFilter,
    additionalFilters: additionalFilters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 306,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_alert_count_by_status.AlertCountByRuleByStatus, {
    entityFilter: entityFilter,
    signalIndexName: signalIndexName,
    additionalFilters: additionalFilters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 21
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_tab_navigation.TabNavigation, {
    navTabs: (0, _nav_tabs.navTabsUsersDetails)(detailName, (0, _has_ml_user_permissions.hasMlUserPermissions)(capabilities)),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 321,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_details_tabs.UsersDetailsTabs, {
    deleteQuery: deleteQuery,
    detailName: detailName,
    filterQuery: stringifiedAdditionalFilters,
    from: from,
    indexNames: selectedPatterns,
    isInitializing: isInitializing,
    userDetailFilter: usersDetailsPageFilters,
    setQuery: setQuery,
    to: to,
    type: _model2.UsersType.details,
    usersDetailsPagePath: usersDetailsPagePath,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 322,
      columnNumber: 13
    }
  }))) : /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 338,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.users,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 341,
      columnNumber: 7
    }
  }));
};
UsersDetailsComponent.displayName = 'UsersDetailsComponent';
const UsersDetails = exports.UsersDetails = /*#__PURE__*/_react.default.memo(UsersDetailsComponent);