"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGeoFieldPropNameToFieldNameMap = exports.SOURCE_GEO_REGION_NAME_FIELD_NAME = exports.SOURCE_GEO_COUNTRY_NAME_FIELD_NAME = exports.SOURCE_GEO_COUNTRY_ISO_CODE_FIELD_NAME = exports.SOURCE_GEO_CONTINENT_NAME_FIELD_NAME = exports.SOURCE_GEO_CITY_NAME_FIELD_NAME = exports.GeoFields = exports.DESTINATION_GEO_REGION_NAME_FIELD_NAME = exports.DESTINATION_GEO_COUNTRY_NAME_FIELD_NAME = exports.DESTINATION_GEO_COUNTRY_ISO_CODE_FIELD_NAME = exports.DESTINATION_GEO_CONTINENT_NAME_FIELD_NAME = exports.DESTINATION_GEO_CITY_NAME_FIELD_NAME = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _draggables = require("../../../../common/components/draggables");
var _country_flag = require("./country_flag");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/explore/network/components/source_destination/geo_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SOURCE_GEO_CONTINENT_NAME_FIELD_NAME = exports.SOURCE_GEO_CONTINENT_NAME_FIELD_NAME = 'source.geo.continent_name';
const SOURCE_GEO_COUNTRY_NAME_FIELD_NAME = exports.SOURCE_GEO_COUNTRY_NAME_FIELD_NAME = 'source.geo.country_name';
const SOURCE_GEO_COUNTRY_ISO_CODE_FIELD_NAME = exports.SOURCE_GEO_COUNTRY_ISO_CODE_FIELD_NAME = 'source.geo.country_iso_code';
const SOURCE_GEO_REGION_NAME_FIELD_NAME = exports.SOURCE_GEO_REGION_NAME_FIELD_NAME = 'source.geo.region_name';
const SOURCE_GEO_CITY_NAME_FIELD_NAME = exports.SOURCE_GEO_CITY_NAME_FIELD_NAME = 'source.geo.city_name';
const DESTINATION_GEO_CONTINENT_NAME_FIELD_NAME = exports.DESTINATION_GEO_CONTINENT_NAME_FIELD_NAME = 'destination.geo.continent_name';
const DESTINATION_GEO_COUNTRY_NAME_FIELD_NAME = exports.DESTINATION_GEO_COUNTRY_NAME_FIELD_NAME = 'destination.geo.country_name';
const DESTINATION_GEO_COUNTRY_ISO_CODE_FIELD_NAME = exports.DESTINATION_GEO_COUNTRY_ISO_CODE_FIELD_NAME = 'destination.geo.country_iso_code';
const DESTINATION_GEO_REGION_NAME_FIELD_NAME = exports.DESTINATION_GEO_REGION_NAME_FIELD_NAME = 'destination.geo.region_name';
const DESTINATION_GEO_CITY_NAME_FIELD_NAME = exports.DESTINATION_GEO_CITY_NAME_FIELD_NAME = 'destination.geo.city_name';
const geoPropNameToFieldNameSuffix = [{
  prop: 'GeoContinentName',
  fieldName: 'geo.continent_name'
}, {
  prop: 'GeoCountryName',
  fieldName: 'geo.country_name'
}, {
  prop: 'GeoCountryIsoCode',
  fieldName: 'geo.country_iso_code'
}, {
  prop: 'GeoRegionName',
  fieldName: 'geo.region_name'
}, {
  prop: 'GeoCityName',
  fieldName: 'geo.city_name'
}];
const getGeoFieldPropNameToFieldNameMap = type => geoPropNameToFieldNameSuffix.map(({
  prop,
  fieldName
}) => ({
  prop: `${type}${prop}`,
  fieldName: `${type}.${fieldName}`
}));
exports.getGeoFieldPropNameToFieldNameMap = getGeoFieldPropNameToFieldNameMap;
const GeoFlexItem = (0, _styled.default)(_eui.EuiFlexItem)`
  margin-right: 5px;
`;
GeoFlexItem.displayName = 'GeoFlexItem';
const GeoFieldValues = /*#__PURE__*/_react.default.memo(({
  contextId,
  eventId,
  fieldName,
  values,
  scopeId
}) => values != null ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (0, _fp.uniq)(values).map(value => /*#__PURE__*/_react.default.createElement(GeoFlexItem, {
  grow: false,
  key: `${contextId}-${eventId}-${fieldName}-${value}`,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 82,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "none",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 83,
    columnNumber: 11
  }
}, fieldName === SOURCE_GEO_COUNTRY_ISO_CODE_FIELD_NAME || fieldName === DESTINATION_GEO_COUNTRY_ISO_CODE_FIELD_NAME ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 86,
    columnNumber: 15
  }
}, /*#__PURE__*/_react.default.createElement(_country_flag.CountryFlag, {
  countryCode: value,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 87,
    columnNumber: 17
  }
})) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 91,
    columnNumber: 13
  }
}, /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
  scopeId: scopeId,
  "data-test-subj": fieldName,
  field: fieldName,
  id: `geo-field-values-default-draggable-${contextId}-${eventId}-${fieldName}-${value}`,
  tooltipContent: fieldName,
  value: value,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 92,
    columnNumber: 15
  }
})))))) : null);
GeoFieldValues.displayName = 'GeoFieldValues';

/**
 * Renders a row of draggable text containing geographic fields, such as:
 * - `source|destination.geo.continent_name`
 * - `source|destination.geo.country_name`
 * - `source|destination.geo.country_iso_code`
 * - `source|destination.geo.region_iso_code`
 * - `source|destination.geo.city_name`
 */
const GeoFields = exports.GeoFields = /*#__PURE__*/_react.default.memo(props => {
  const {
    contextId,
    eventId,
    type,
    scopeId
  } = props;
  const propNameToFieldName = getGeoFieldPropNameToFieldNameMap(type);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 5
    }
  }, (0, _fp.uniq)(propNameToFieldName).map(geo => /*#__PURE__*/_react.default.createElement(GeoFieldValues, {
    scopeId: scopeId,
    contextId: contextId,
    eventId: eventId,
    fieldName: geo.fieldName,
    key: geo.fieldName,
    values: (0, _fp.get)(geo.prop, props),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  })));
});
GeoFields.displayName = 'GeoFields';