"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFormattedComments = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _moment = _interopRequireDefault(require("moment"));
var i18n = _interopRequireWildcard(require("./translations"));
var _with_copy_to_clipboard = require("../../common/lib/clipboard/with_copy_to_clipboard");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/exceptions/utils/ui.helpers.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const commentCss = (0, _react2.css)`
  white-space: pre-wrap;
`;

/**
 * Formats ExceptionItem.comments into EuiCommentList format
 *
 * @param comments ExceptionItem.comments
 */
const getFormattedComments = comments => comments.map(commentItem => ({
  username: commentItem.created_by,
  timestamp: (0, _moment.default)(commentItem.created_at).format('on MMM Do YYYY @ HH:mm:ss'),
  event: i18n.COMMENT_EVENT,
  timelineAvatar: /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
    size: "l",
    name: commentItem.created_by.toUpperCase(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 21
    }
  }),
  children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: commentCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }, commentItem.comment),
  actions: /*#__PURE__*/_react.default.createElement(_with_copy_to_clipboard.WithCopyToClipboard, {
    "data-test-subj": "copy-to-clipboard",
    text: commentItem.comment,
    titleSummary: i18n.ADD_TO_CLIPBOARD,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  })
}));
exports.getFormattedComments = getFormattedComments;