"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrivilegedAccessDetectionMLPopoverHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _use_integration_link_state = require("../../../../../../common/hooks/integrations/use_integration_link_state");
var _constants = require("../../../../../../../common/constants");
var _use_integrations = require("../../../../privileged_user_monitoring_onboarding/hooks/use_integrations");
var _constants2 = require("../../../../../../common/lib/integrations/constants");
var _integrations = require("../../../../../../common/utils/integrations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/privileged_user_monitoring/components/privileged_access_detection/pad_ml_popover/pad_ml_popover_header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PrivilegedAccessDetectionMLPopoverHeader = () => {
  const state = (0, _use_integration_link_state.useIntegrationLinkState)(_constants.ENTITY_ANALYTICS_PRIVILEGED_USER_MONITORING_PATH);
  const {
    navigateTo
  } = (0, _securitySolutionNavigation.useNavigation)();
  const padPackage = (0, _use_integrations.usePrivilegedAccessDetectionIntegration)();
  const navigateToPadIntegration = (0, _react.useCallback)(() => {
    navigateTo({
      appId: _constants2.INTEGRATION_APP_ID,
      path: (0, _integrations.addPathParamToUrl)(`/detail/${padPackage === null || padPackage === void 0 ? void 0 : padPackage.name}-${padPackage === null || padPackage === void 0 ? void 0 : padPackage.version}/overview`, _constants.ENTITY_ANALYTICS_PRIVILEGED_USER_MONITORING_PATH),
      state
    });
  }, [navigateTo, padPackage, state]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.entityAnalytics.privilegedUserMonitoring.privilegedAccessDetection.padMlJobsDescription",
    defaultMessage: "Run privileged access detection jobs to monitor anomalous behaviors of privileged users in your environment. Note that some jobs may require additional manual steps configured in order to fully function. See the {integrationLink} for details",
    values: {
      integrationLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        external: true,
        onClick: navigateToPadIntegration,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 41,
          columnNumber: 15
        }
      }, 'Privileged access detection integration')
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 9
    }
  })));
};
exports.PrivilegedAccessDetectionMLPopoverHeader = PrivilegedAccessDetectionMLPopoverHeader;