"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskInputsTab = exports.RISK_INPUTS_TAB_QUERY_ID = exports.EXPAND_ALERT_TEST_ID = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _fp = require("lodash/fp");
var _alert_preview_button = require("../../../../../flyout/shared/components/alert_preview_button");
var _use_global_time = require("../../../../../common/containers/use_global_time");
var _manage_query = require("../../../../../common/components/page/manage_query");
var _common = require("../../../../common");
var _use_risk_contributing_alerts = require("../../../../hooks/use_risk_contributing_alerts");
var _formatted_date = require("../../../../../common/components/formatted_date");
var _use_risk_score = require("../../../../api/hooks/use_risk_score");
var _search_strategy = require("../../../../../../common/search_strategy");
var _asset_criticality = require("../../../asset_criticality");
var _utility_bar = require("../../components/utility_bar");
var _action_column = require("../../components/action_column");
var _ask_ai_assistant = require("./ask_ai_assistant");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/entity_analytics/components/entity_details_flyout/tabs/risk_inputs/risk_inputs_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FIRST_RECORD_PAGINATION = {
  cursorStart: 0,
  querySize: 1
};
const EXPAND_ALERT_TEST_ID = exports.EXPAND_ALERT_TEST_ID = 'risk-input-alert-preview-button';
const RISK_INPUTS_TAB_QUERY_ID = exports.RISK_INPUTS_TAB_QUERY_ID = 'RiskInputsTabQuery';
const RiskInputsTab = ({
  entityType,
  entityName,
  scopeId
}) => {
  const {
    setQuery,
    deleteQuery
  } = (0, _use_global_time.useGlobalTime)();
  const [selectedItems, setSelectedItems] = (0, _react.useState)([]);
  const nameFilterQuery = (0, _react.useMemo)(() => {
    return (0, _search_strategy.buildEntityNameFilter)(entityType, [entityName]);
  }, [entityName, entityType]);
  const {
    data: riskScoreData,
    error: riskScoreError,
    loading: loadingRiskScore,
    inspect: inspectRiskScore,
    refetch
  } = (0, _use_risk_score.useRiskScore)({
    riskEntity: entityType,
    filterQuery: nameFilterQuery,
    onlyLatest: false,
    pagination: FIRST_RECORD_PAGINATION,
    skip: nameFilterQuery === undefined
  });
  (0, _manage_query.useQueryInspector)({
    deleteQuery,
    inspect: inspectRiskScore,
    loading: loadingRiskScore,
    queryId: RISK_INPUTS_TAB_QUERY_ID,
    refetch,
    setQuery
  });
  const riskScore = riskScoreData && riskScoreData.length > 0 ? riskScoreData[0] : undefined;
  const alerts = (0, _use_risk_contributing_alerts.useRiskContributingAlerts)({
    riskScore,
    entityType
  });
  const euiTableSelectionProps = (0, _react.useMemo)(() => ({
    initialSelected: [],
    selectable: () => true,
    onSelectionChange: setSelectedItems
  }), []);
  const inputColumns = (0, _react.useMemo)(() => [{
    render: data => /*#__PURE__*/_react.default.createElement(_alert_preview_button.AlertPreviewButton, {
      id: data._id,
      indexName: data.input.index,
      scopeId: scopeId,
      "data-test-subj": EXPAND_ALERT_TEST_ID,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 11
      }
    }),
    width: '5%'
  }, {
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.riskInputs.actionsColumn",
      defaultMessage: "Actions",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 11
      }
    }),
    width: '80px',
    render: data => /*#__PURE__*/_react.default.createElement(_action_column.ActionColumn, {
      input: data,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 39
      }
    })
  }, {
    field: 'input.timestamp',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.riskInputs.dateColumn",
      defaultMessage: "Date",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 11
      }
    }),
    truncateText: false,
    mobileOptions: {
      show: true
    },
    sortable: true,
    width: '30%',
    render: timestamp => /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
      value: new Date(timestamp),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 40
      }
    })
  }, {
    field: 'alert',
    'data-test-subj': 'risk-input-table-description-cell',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.riskInputs.riskInputColumn",
      defaultMessage: "Rule name",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 11
      }
    }),
    truncateText: true,
    mobileOptions: {
      show: true
    },
    sortable: true,
    render: alert => (0, _fp.get)(_ruleDataUtils.ALERT_RULE_NAME, alert)
  }, {
    field: 'input.contribution_score',
    'data-test-subj': 'risk-input-table-contribution-cell',
    name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.riskInputs.contributionColumn",
      defaultMessage: "Contribution",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 11
      }
    }),
    truncateText: false,
    mobileOptions: {
      show: true
    },
    sortable: true,
    align: 'right',
    render: formatContribution
  }], [scopeId]);
  if (riskScoreError) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.entityDetails.riskInputs.errorTitle",
        defaultMessage: "Something went wrong",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 170,
          columnNumber: 11
        }
      }),
      color: "danger",
      iconType: "error",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.riskInputs.errorBody",
      defaultMessage: "Error while fetching risk inputs. Please try again later.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 11
      }
    })));
  }
  const riskInputsAlertSection = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    "data-test-subj": "risk-input-alert-title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.riskInputs.alertsTitle",
    defaultMessage: "Alerts",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_utility_bar.RiskInputsUtilityBar, {
    riskInputs: selectedItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    compressed: true,
    loading: loadingRiskScore || alerts.loading,
    items: alerts.data || [],
    columns: inputColumns,
    sorting: true,
    selection: euiTableSelectionProps,
    itemId: "_id",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(ExtraAlertsMessage, {
    riskScore: riskScore,
    alerts: alerts,
    entityType: entityType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(ContextsSection, {
    loading: loadingRiskScore,
    riskScore: riskScore,
    entityType: entityType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 7
    }
  }), riskInputsAlertSection, /*#__PURE__*/_react.default.createElement(_ask_ai_assistant.AskAiAssistant, {
    entityType: entityType,
    entityName: entityName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 7
    }
  }));
};
exports.RiskInputsTab = RiskInputsTab;
RiskInputsTab.displayName = 'RiskInputsTab';
const ContextsSection = ({
  riskScore,
  loading,
  entityType
}) => {
  const criticality = (0, _react.useMemo)(() => {
    if (!riskScore) {
      return undefined;
    }
    return {
      level: riskScore[entityType].risk.criticality_level,
      contribution: riskScore[entityType].risk.category_2_score
    };
  }, [entityType, riskScore]);
  if (loading || criticality === undefined) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    "data-test-subj": "risk-input-contexts-title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.riskInputs.contextsTitle",
    defaultMessage: "Contexts",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    compressed: true,
    loading: loading,
    "data-test-subj": "risk-input-contexts-table",
    columns: contextColumns,
    items: [{
      field: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.entityDetails.riskInputs.assetCriticalityField",
        defaultMessage: "Asset Criticality Level",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 275,
          columnNumber: 15
        }
      }),
      value: /*#__PURE__*/_react.default.createElement(_asset_criticality.AssetCriticalityBadge, {
        criticalityLevel: criticality.level,
        dataTestSubj: "risk-inputs-asset-criticality-badge",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 281,
          columnNumber: 15
        }
      }),
      contribution: formatContribution(criticality.contribution || 0)
    }],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 7
    }
  }));
};
const contextColumns = [{
  field: 'field',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.riskInputs.fieldColumn",
    defaultMessage: "Field",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 7
    }
  }),
  width: '30%',
  render: field => field
}, {
  field: 'value',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.riskInputs.valueColumn",
    defaultMessage: "Value",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 7
    }
  }),
  width: '30%',
  render: val => val
}, {
  field: 'contribution',
  width: '30%',
  align: 'right',
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.riskInputs.contributionColumn",
    defaultMessage: "Contribution",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 328,
      columnNumber: 7
    }
  }),
  render: score => score
}];
const ExtraAlertsMessage = ({
  riskScore,
  alerts,
  entityType
}) => {
  var _alerts$data, _alerts$data2;
  const totals = !riskScore ? {
    count: 0,
    score: 0
  } : {
    count: riskScore[entityType].risk.category_1_count,
    score: riskScore[entityType].risk.category_1_score
  };
  const displayed = {
    count: ((_alerts$data = alerts.data) === null || _alerts$data === void 0 ? void 0 : _alerts$data.length) || 0,
    score: ((_alerts$data2 = alerts.data) === null || _alerts$data2 === void 0 ? void 0 : _alerts$data2.reduce((sum, {
      input
    }) => sum + (input.contribution_score || 0), 0)) || 0
  };
  if (displayed.count >= totals.count) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "risk-input-extra-alerts-message",
    size: "s",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.riskInputs.extraAlertsMessage",
      defaultMessage: "{count} more alerts contributed {score} to the calculated risk score",
      values: {
        count: totals.count - displayed.count,
        score: formatContribution(totals.score - displayed.score)
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 368,
        columnNumber: 9
      }
    }),
    iconType: "annotation",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 364,
      columnNumber: 5
    }
  });
};
const formatContribution = value => {
  const fixedValue = (0, _common.formatRiskScore)(value);

  // prevent +0.00 for values like 0.0001
  if (fixedValue === '0.00') {
    return fixedValue;
  }
  if (value > 0) {
    return `+${fixedValue}`;
  }
  return fixedValue;
};