"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertTableCellContextProvider = exports.AlertTableCellContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _use_license = require("../../../common/hooks/use_license");
var _use_selector = require("../../../common/hooks/use_selector");
var _containers = require("../../../sourcerer/containers");
var _constants = require("../../../../common/constants");
var _source = require("../../../common/containers/source");
var _columns = require("./columns");
var _use_browser_fields = require("../../../data_view_manager/hooks/use_browser_fields");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/configurations/security_solution_detections/cell_value_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AlertTableCellContext = exports.AlertTableCellContext = /*#__PURE__*/(0, _react.createContext)(null);
const AlertTableCellContextProvider = ({
  tableId = '',
  sourcererScope,
  children
}) => {
  var _useDeepEqualSelector;
  const {
    browserFields: oldBrowserFields
  } = (0, _containers.useSourcererDataView)(sourcererScope);
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const experimentalBrowserFields = (0, _use_browser_fields.useBrowserFields)(sourcererScope);
  const browserFields = newDataViewPickerEnabled ? experimentalBrowserFields : oldBrowserFields;
  const browserFieldsByName = (0, _react.useMemo)(() => (0, _source.getAllFieldsByName)(browserFields), [browserFields]);
  const license = (0, _use_license.useLicense)();
  const gridColumns = (0, _react.useMemo)(() => {
    return (0, _columns.getColumns)(license);
  }, [license]);
  const getTable = (0, _react.useMemo)(() => _securitysolutionDataTable.dataTableSelectors.getTableByIdSelector(), []);
  const viewMode = (_useDeepEqualSelector = (0, _use_selector.useDeepEqualSelector)(state => {
    var _getTable;
    return ((_getTable = getTable(state, tableId !== null && tableId !== void 0 ? tableId : '')) !== null && _getTable !== void 0 ? _getTable : _securitysolutionDataTable.tableDefaults).viewMode;
  })) !== null && _useDeepEqualSelector !== void 0 ? _useDeepEqualSelector : _securitysolutionDataTable.tableDefaults.viewMode;
  const columnHeaders = (0, _react.useMemo)(() => {
    return viewMode === _constants.VIEW_SELECTION.gridView ? gridColumns : _columns.eventRenderedViewColumns;
  }, [gridColumns, viewMode]);
  const cellValueContext = (0, _react.useMemo)(() => ({
    browserFields,
    browserFieldsByName,
    columnHeaders
  }), [browserFields, browserFieldsByName, columnHeaders]);
  return /*#__PURE__*/_react.default.createElement(AlertTableCellContext.Provider, {
    value: cellValueContext,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 5
    }
  }, children);
};
exports.AlertTableCellContextProvider = AlertTableCellContextProvider;