"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdatedBy = exports.CreatedBy = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _translations = require("./translations");
var _formatted_date = require("../../../../common/components/formatted_date");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/rules/rule_info/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Created by and created at text that are shown on rule details and rule preview in expandable flyout
 */
const CreatedBy = ({
  createdBy,
  createdAt,
  'data-test-subj': dataTestSubj
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.ruleDetails.ruleCreationDescription",
    defaultMessage: "Created by: {by} on {date}",
    values: {
      by: createdBy !== null && createdBy !== void 0 ? createdBy : _translations.UNKNOWN_TEXT,
      date: /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
        value: createdAt !== null && createdAt !== void 0 ? createdAt : new Date().toISOString(),
        fieldName: "createdAt",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 35,
          columnNumber: 13
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 7
    }
  }));
};
exports.CreatedBy = CreatedBy;
CreatedBy.displayName = 'CreatedBy';
/**
 * Updated by and updated at text that are shown on rule details and rule preview in expandable flyout
 */
const UpdatedBy = ({
  updatedBy,
  updatedAt,
  'data-test-subj': dataTestSubj
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.ruleDetails.ruleUpdateDescription",
    defaultMessage: "Updated by: {by} on {date}",
    values: {
      by: updatedBy !== null && updatedBy !== void 0 ? updatedBy : _translations.UNKNOWN_TEXT,
      date: /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedDate, {
        value: updatedAt !== null && updatedAt !== void 0 ? updatedAt : new Date().toISOString(),
        fieldName: "updatedAt",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 67,
          columnNumber: 13
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }));
};
exports.UpdatedBy = UpdatedBy;
UpdatedBy.displayName = 'UpdatedBy';