"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAlertsContext = exports.AlertsContextProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts_table/alerts_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Temporary context to share imperative APIs between the alerts table and other higher level
 * components such as the alerts details flyout
 *
 * TODO remove once the alerts table columns are controllable from the outside
 */
const AlertsContext = /*#__PURE__*/(0, _react.createContext)(null);
const AlertsContextProviderComponent = ({
  children
}) => {
  const alertsTableRef = (0, _react.useRef)(null);
  const contextValue = (0, _react.useMemo)(() => ({
    alertsTableRef
  }), []);
  return /*#__PURE__*/_react.default.createElement(AlertsContext.Provider, {
    value: contextValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 10
    }
  }, children);
};
const AlertsContextProvider = exports.AlertsContextProvider = /*#__PURE__*/(0, _react.memo)(AlertsContextProviderComponent);
const useAlertsContext = () => {
  const fallbackRef = (0, _react.useRef)(null);
  const value = (0, _react.useContext)(AlertsContext);
  if (!value) {
    return {
      alertsTableRef: fallbackRef
    };
  }
  return value;
};
exports.useAlertsContext = useAlertsContext;