"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DETECTIONS_ALERTS_COUNT_ID = exports.AlertsCountPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _header_section = require("../../../../common/components/header_section");
var _inspect = require("../../../../common/components/inspect");
var i18n = _interopRequireWildcard(require("./translations"));
var _components = require("../common/components");
var _field_selection = require("../common/field_selection");
var _alerts_table = require("../../../../common/components/visualization_actions/lens_attributes/common/alerts/alerts_table");
var _model = require("../../../../sourcerer/store/model");
var _visualization_embeddable = require("../../../../common/components/visualization_actions/visualization_embeddable");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts_kpis/alerts_count_panel/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DETECTIONS_ALERTS_COUNT_ID = exports.DETECTIONS_ALERTS_COUNT_ID = 'detections-alerts-count';
const CHART_HEIGHT = 218; // px

const AlertsCountPanel = exports.AlertsCountPanel = /*#__PURE__*/(0, _react.memo)(({
  alignHeader,
  chartOptionsContextMenu,
  extraActions,
  filters,
  inspectTitle,
  panelHeight,
  setStackByField0,
  setStackByField0ComboboxInputRef,
  setStackByField1,
  setStackByField1ComboboxInputRef,
  stackByField0,
  stackByField0ComboboxRef,
  stackByField1,
  stackByField1ComboboxRef,
  stackByWidth,
  title = i18n.COUNT_TABLE_TITLE,
  isExpanded,
  setIsExpanded,
  signalIndexName
}) => {
  const {
    to,
    from
  } = (0, _use_global_time.useGlobalTime)();
  // create a unique, but stable (across re-renders) query id
  const uniqueQueryId = (0, _react.useMemo)(() => `${DETECTIONS_ALERTS_COUNT_ID}-${(0, _uuid.v4)()}`, []);
  const timerange = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  const extraVisualizationOptions = (0, _react.useMemo)(() => ({
    breakdownField: stackByField1,
    filters
  }), [filters, stackByField1]);
  return /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, {
    show: isExpanded,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_components.KpiPanel, {
    $toggleStatus: Boolean(isExpanded),
    "data-test-subj": "alertsCountPanel",
    hasBorder: true,
    height: panelHeight,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    alignHeader: alignHeader,
    id: uniqueQueryId,
    inspectTitle: inspectTitle,
    outerDirection: "row",
    title: title,
    titleSize: "s",
    hideSubtitle: true,
    showInspectButton: chartOptionsContextMenu == null,
    toggleStatus: isExpanded,
    toggleQuery: setIsExpanded,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_field_selection.FieldSelection, {
    setStackByField0: setStackByField0,
    setStackByField0ComboboxInputRef: setStackByField0ComboboxInputRef,
    setStackByField1: setStackByField1,
    setStackByField1ComboboxInputRef: setStackByField1ComboboxInputRef,
    stackByField0: stackByField0,
    stackByField0ComboboxRef: stackByField0ComboboxRef,
    stackByField1: stackByField1,
    stackByField1ComboboxRef: stackByField1ComboboxRef,
    stackByWidth: stackByWidth,
    uniqueQueryId: uniqueQueryId,
    useLensCompatibleFields: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 13
    }
  })), isExpanded && /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    signalIndexName: signalIndexName,
    "data-test-subj": "embeddable-alerts-count",
    extraActions: extraActions,
    extraOptions: extraVisualizationOptions,
    getLensAttributes: _alerts_table.getAlertsTableLensAttributes,
    height: CHART_HEIGHT,
    id: `${uniqueQueryId}-embeddable`,
    inspectTitle: inspectTitle,
    scopeId: _model.SourcererScopeName.detections,
    stackByField: stackByField0,
    timerange: timerange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 13
    }
  })));
});
AlertsCountPanel.displayName = 'AlertsCountPanel';