"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CoverageOverviewFiltersPanel = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _css = require("@emotion/css");
var _dashboard_legend = require("./shared_components/dashboard_legend");
var i18n = _interopRequireWildcard(require("./translations"));
var _coverage_overview_dashboard_context = require("./coverage_overview_dashboard_context");
var _rule_activity_filter = require("./rule_activity_filter");
var _rule_source_filter = require("./rule_source_filter");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/pages/coverage_overview/filters_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CoverageOverviewFiltersPanelComponent = () => {
  var _filter$activity, _filter$source;
  const {
    state: {
      filter,
      isLoading,
      showExpandedCells
    },
    actions: {
      setShowExpandedCells,
      setRuleActivityFilter,
      setRuleSourceFilter,
      setRuleSearchFilter
    }
  } = (0, _coverage_overview_dashboard_context.useCoverageOverviewDashboardContext)();
  const handleExpandCellsFilterClick = () => setShowExpandedCells(true);
  const handleCollapseCellsFilterClick = () => setShowExpandedCells(false);
  const handleRuleSearchOnChange = (0, _react.useCallback)(queryText => {
    setRuleSearchFilter(queryText === null || queryText === void 0 ? void 0 : queryText.trim());
  }, [setRuleSearchFilter]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _css.css)`
              flex-grow: 0;
            `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_rule_activity_filter.RuleActivityFilter, {
    onChange: setRuleActivityFilter,
    isLoading: isLoading,
    selected: (_filter$activity = filter.activity) !== null && _filter$activity !== void 0 ? _filter$activity : [],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_rule_source_filter.RuleSourceFilter, {
    onChange: setRuleSourceFilter,
    isLoading: isLoading,
    selected: (_filter$source = filter.source) !== null && _filter$source !== void 0 ? _filter$source : [],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    fullWidth: true,
    incremental: false,
    "data-test-subj": "coverageOverviewFilterSearchBar",
    placeholder: i18n.CoverageOverviewSearchBarPlaceholder,
    onSearch: handleRuleSearchOnChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    withNext: true,
    isToggle: true,
    isSelected: !showExpandedCells,
    hasActiveFilters: !showExpandedCells,
    onClick: handleCollapseCellsFilterClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 17
    }
  }, i18n.COLLAPSE_CELLS_FILTER_BUTTON), /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    isToggle: true,
    isSelected: showExpandedCells,
    hasActiveFilters: showExpandedCells,
    onClick: handleExpandCellsFilterClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 17
    }
  }, i18n.EXPAND_CELLS_FILTER_BUTTON))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_dashboard_legend.CoverageOverviewLegend, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 11
    }
  }))));
};
const CoverageOverviewFiltersPanel = exports.CoverageOverviewFiltersPanel = /*#__PURE__*/(0, _react.memo)(CoverageOverviewFiltersPanelComponent);