"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpgradeWithConflictsModal = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _use_upgrade_modal = require("./use_upgrade_modal");
var i18n = _interopRequireWildcard(require("./translations"));
var _conflicts_description = require("./conflicts_description");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/upgrade_prebuilt_rules_table/use_upgrade_with_conflicts_modal/upgrade_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UpgradeWithConflictsModal = exports.UpgradeWithConflictsModal = /*#__PURE__*/(0, _react.memo)(function ConfirmUpgradeWithConflictsModal({
  numOfRulesWithoutConflicts,
  numOfRulesWithSolvableConflicts,
  numOfRulesWithNonSolvableConflicts,
  onCancel,
  onConfirm
}) {
  const confirmUpgradingRulesWithoutConflicts = (0, _react.useCallback)(() => onConfirm(_use_upgrade_modal.ConfirmRulesUpgrade.WithoutConflicts), [onConfirm]);
  const confirmUpgradingRulesWithSolvableConflicts = (0, _react.useCallback)(() => onConfirm(_use_upgrade_modal.ConfirmRulesUpgrade.WithSolvableConflicts), [onConfirm]);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "data-test-subj": "upgradeConflictsModal",
    onClose: onCancel,
    "aria-labelledby": modalTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 9
    }
  }, i18n.UPGRADE_CONFLICTS_MODAL_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_conflicts_description.ConflictsDescription, {
    numOfRulesWithoutConflicts: numOfRulesWithoutConflicts,
    numOfRulesWithSolvableConflicts: numOfRulesWithSolvableConflicts,
    numOfRulesWithNonSolvableConflicts: numOfRulesWithNonSolvableConflicts,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, numOfRulesWithoutConflicts > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: confirmUpgradingRulesWithoutConflicts,
    "data-test-subj": "conflicts-modal-upgrade-conflict-free-rules",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  }, i18n.UPGRADE_RULES_WITHOUT_CONFLICTS(numOfRulesWithoutConflicts)), numOfRulesWithSolvableConflicts > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: confirmUpgradingRulesWithSolvableConflicts,
    color: "warning",
    "data-test-subj": "conflicts-modal-upgrade-rules-with-solvable-conflicts",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 11
    }
  }, i18n.UPGRADE_RULES_WITH_CONFLICTS(numOfRulesWithoutConflicts + numOfRulesWithSolvableConflicts)), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onCancel,
    "data-test-subj": "conflicts-modal-cancel",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 9
    }
  }, i18n.UPGRADE_CONFLICTS_MODAL_CANCEL)));
});