"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPDATE_SELECTED_RULES = exports.UPDATE_FLYOUT_PER_FIELD_TOOLTIP_DESCRIPTION = exports.UPDATE_FLYOUT_JSON_VIEW_TOOLTIP_DESCRIPTION = exports.UPDATE_BUTTON_LABEL = exports.UPDATE_ALL = exports.UPDATED_VERSION_DESCRIPTION = exports.UPDATED_BY_AND_WHEN = exports.SEVERITY = exports.SEARCH_PLACEHOLDER = exports.RULE_TYPE_CHANGE_WITH_CUSTOMIZATIONS_CALLOUT_DESCRIPTION = exports.RULE_TYPE_CHANGE_CALLOUT_TITLE = exports.RULE_TYPE_CHANGE_CALLOUT_DESCRIPTION = exports.RULE_NEW_VERSION_DETECTED_WARNING_DESCRIPTION = exports.RULE_NEW_VERSION_DETECTED_WARNING = exports.RULE_NEW_REVISION_DETECTED_WARNING_DESCRIPTION = exports.RULE_NEW_REVISION_DETECTED_WARNING = exports.RULE_MODIFIED_BADGE_DESCRIPTION = exports.MODIFIED_RULE_UPGRADE_LICENSE_INSUFFICIENT_CALLOUT_DESCRIPTION = exports.LAST_UPDATE = exports.FIELD_UPDATES = exports.ELASTIC_UPDATE_VERSION = exports.CURRENT_VERSION_DESCRIPTION = exports.CURRENT_RULE_VERSION = exports.BULK_UPDATE_SELECTED_RULES_BUTTON_TOOLTIP_CONFLICTS = exports.BULK_UPDATE_BUTTON_TOOLTIP_NO_PERMISSIONS = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/upgrade_prebuilt_rules_table/translations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const UPDATE_ALL = exports.UPDATE_ALL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.upgradeAll', {
  defaultMessage: 'Update all'
});
const UPDATE_SELECTED_RULES = numberOfSelectedRules => {
  return _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.upgradeSelected', {
    defaultMessage: 'Update {numberOfSelectedRules} selected rule(s)',
    values: {
      numberOfSelectedRules
    }
  });
};
exports.UPDATE_SELECTED_RULES = UPDATE_SELECTED_RULES;
const BULK_UPDATE_BUTTON_TOOLTIP_NO_PERMISSIONS = exports.BULK_UPDATE_BUTTON_TOOLTIP_NO_PERMISSIONS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.bulkButtons.noPermissions', {
  defaultMessage: "You don't have permissions to update rules"
});
const BULK_UPDATE_SELECTED_RULES_BUTTON_TOOLTIP_CONFLICTS = exports.BULK_UPDATE_SELECTED_RULES_BUTTON_TOOLTIP_CONFLICTS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.bulkButtons.selectedRules.conflicts', {
  defaultMessage: 'The selected rules have conflicts that must be manually resolved.'
});
const SEARCH_PLACEHOLDER = exports.SEARCH_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.searchBarPlaceholder', {
  defaultMessage: 'Search by rule name'
});
const UPDATE_BUTTON_LABEL = exports.UPDATE_BUTTON_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.updateButtonLabel', {
  defaultMessage: 'Update rule'
});
const UPDATE_FLYOUT_PER_FIELD_TOOLTIP_DESCRIPTION = exports.UPDATE_FLYOUT_PER_FIELD_TOOLTIP_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.perFieldTooltip', {
  defaultMessage: 'View changes field by field.'
});
const UPDATE_FLYOUT_JSON_VIEW_TOOLTIP_DESCRIPTION = exports.UPDATE_FLYOUT_JSON_VIEW_TOOLTIP_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleDetails.jsonViewTooltip', {
  defaultMessage: 'View the latest rule changes in JSON format.'
});
const RULE_TYPE_CHANGE_CALLOUT_TITLE = exports.RULE_TYPE_CHANGE_CALLOUT_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.upgradeRules.ruleTypeChangeCalloutTitle', {
  defaultMessage: 'Rule type change'
});
const RULE_TYPE_CHANGE_CALLOUT_DESCRIPTION = exports.RULE_TYPE_CHANGE_CALLOUT_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.upgradeRules.ruleTypeChangeCalloutDescription', {
  defaultMessage: 'The rule type will change if you update this rule.'
});
const MODIFIED_RULE_UPGRADE_LICENSE_INSUFFICIENT_CALLOUT_DESCRIPTION = exports.MODIFIED_RULE_UPGRADE_LICENSE_INSUFFICIENT_CALLOUT_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.upgradeRules.ruleUpgradeLicenseInsufficientCalloutDescription', {
  defaultMessage: 'Updating the rule will erase your changes.'
});
const RULE_TYPE_CHANGE_WITH_CUSTOMIZATIONS_CALLOUT_DESCRIPTION = exports.RULE_TYPE_CHANGE_WITH_CUSTOMIZATIONS_CALLOUT_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.upgradeRules.ruleTypeChangeWithCustomizationCalloutDescription', {
  defaultMessage: 'Updating the rule will erase your changes. To save them, first duplicate the rule, then update it.'
});
const LAST_UPDATE = exports.LAST_UPDATE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.upgradeFlyout.header.lastUpdate', {
  defaultMessage: 'Last updated'
});
const UPDATED_BY_AND_WHEN = (updatedBy, updatedAt) => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.detectionEngine.upgradeFlyout.header.updated",
  defaultMessage: "{updatedBy} on {updatedAt}",
  values: {
    updatedBy,
    updatedAt
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 109,
    columnNumber: 3
  }
});
exports.UPDATED_BY_AND_WHEN = UPDATED_BY_AND_WHEN;
const SEVERITY = exports.SEVERITY = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.upgradeFlyout.header.severity', {
  defaultMessage: 'Severity'
});
const FIELD_UPDATES = exports.FIELD_UPDATES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.upgradeFlyout.header.fieldUpdates', {
  defaultMessage: 'Field updates'
});
const RULE_MODIFIED_BADGE_DESCRIPTION = exports.RULE_MODIFIED_BADGE_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.upgradeFlyout.ruleModifiedBadgeDescription', {
  defaultMessage: 'The rule was edited after installation and field values differs from the values upon installation'
});
const RULE_NEW_REVISION_DETECTED_WARNING = exports.RULE_NEW_REVISION_DETECTED_WARNING = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.upgradeFlyout.ruleNewRevisionDetectedWarning', {
  defaultMessage: 'Installed rule changed'
});
const RULE_NEW_REVISION_DETECTED_WARNING_DESCRIPTION = ruleName => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.upgradeFlyout.ruleNewVersionDetectedWarningDescription', {
  defaultMessage: 'Someone edited the installed rule "{ruleName}". Upgrade resolved conflicts were reset.',
  values: {
    ruleName
  }
});
exports.RULE_NEW_REVISION_DETECTED_WARNING_DESCRIPTION = RULE_NEW_REVISION_DETECTED_WARNING_DESCRIPTION;
const RULE_NEW_VERSION_DETECTED_WARNING = exports.RULE_NEW_VERSION_DETECTED_WARNING = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.upgradeFlyout.ruleNewRevisionDetectedWarning', {
  defaultMessage: 'New prebuilt rules package was installed'
});
const RULE_NEW_VERSION_DETECTED_WARNING_DESCRIPTION = ruleName => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.upgradeFlyout.ruleNewRevisionDetectedWarningDescription', {
  defaultMessage: 'Newer prebuilt rules package were installed in background. It contains a newer rule version for "{ruleName}". Upgrade resolved conflicts were reset.',
  values: {
    ruleName
  }
});
exports.RULE_NEW_VERSION_DETECTED_WARNING_DESCRIPTION = RULE_NEW_VERSION_DETECTED_WARNING_DESCRIPTION;
const CURRENT_RULE_VERSION = exports.CURRENT_RULE_VERSION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.currentVersionLabel', {
  defaultMessage: 'Current rule'
});
const CURRENT_VERSION_DESCRIPTION = exports.CURRENT_VERSION_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.currentVersionDescriptionLabel', {
  defaultMessage: 'Shows currently installed rule'
});
const ELASTIC_UPDATE_VERSION = exports.ELASTIC_UPDATE_VERSION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.elasticUpdateVersionLabel', {
  defaultMessage: 'Elastic update'
});
const UPDATED_VERSION_DESCRIPTION = exports.UPDATED_VERSION_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.upgradeRules.updatedVersionDescriptionLabel', {
  defaultMessage: 'Shows rule that will be installed'
});