"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BulkEditDeleteAlertSuppressionConfirmation = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _telemetry = require("../../../../../common/lib/telemetry");
var _rule_management = require("../../../../../../common/api/detection_engine/rule_management");
var _translations = require("./translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/bulk_actions/bulk_edit_delete_alert_suprression_confirmation.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const BulkEditDeleteAlertSuppressionConfirmation = ({
  rulesCount,
  onCancel,
  onConfirm
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: _translations.bulkAlertSuppression.DELETE_CONFIRMATION_TITLE,
    titleProps: {
      id: modalTitleId
    },
    onCancel: onCancel,
    onConfirm: () => {
      onConfirm({
        type: _rule_management.BulkActionEditTypeEnum.delete_alert_suppression
      });
      (0, _telemetry.track)(_telemetry.METRIC_TYPE.CLICK, _telemetry.TELEMETRY_EVENT.SET_ALERT_SUPPRESSION_FOR_THRESHOLD);
    },
    confirmButtonText: _translations.bulkAlertSuppression.DELETE_CONFIRMATION_CONFIRM,
    cancelButtonText: _translations.bulkAlertSuppression.DELETE_CONFIRMATION_CANCEL,
    buttonColor: "danger",
    defaultFocusedButton: "confirm",
    "data-test-subj": "deleteRulesConfirmationModal",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.alertSuppression.deleteAlertSuppressionConfirmationModalBody",
    defaultMessage: "This action will remove alert suppression from {rulesCount, plural, one {the chosen rule} other {{rulesCountStrong} rules}}. Click {deleteStrong} to continue.",
    values: {
      rulesCount,
      rulesCountStrong: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 52,
          columnNumber: 29
        }
      }, rulesCount),
      deleteStrong: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 54,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.detectionEngine.rules.allRules.bulkActions.edit.alertSuppression.deleteAlertSuppressionConfirmationModalBodyDeleteBtnLabel",
        defaultMessage: "Delete",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 55,
          columnNumber: 15
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }));
};
exports.BulkEditDeleteAlertSuppressionConfirmation = BulkEditDeleteAlertSuppressionConfirmation;
BulkEditDeleteAlertSuppressionConfirmation.displayName = 'BulkEditDeleteAlertSuppressionConfirmation';