"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldUpgradeStateInfo = FieldUpgradeStateInfo;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _utility_types = require("../../../../../../../../common/utility_types");
var _prebuilt_rule_upgrade = require("../../../../../model/prebuilt_rule_upgrade");
var _ready_for_upgrade_badge = require("../../badges/ready_for_upgrade_badge");
var _review_required_badge = require("../../badges/review_required_badge");
var _action_required = require("../../badges/action_required");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/rule_upgrade/field_upgrade_state_info/field_upgrade_state_info.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function FieldUpgradeStateInfo({
  state
}) {
  const {
    color,
    badge,
    title,
    description
  } = (0, _react.useMemo)(() => {
    switch (state) {
      case _prebuilt_rule_upgrade.FieldUpgradeStateEnum.NoUpdate:
        return {
          color: 'default',
          title: i18n.NO_UPDATE,
          description: i18n.NO_UPDATE_DESCRIPTION
        };
      case _prebuilt_rule_upgrade.FieldUpgradeStateEnum.SameUpdate:
        return {
          color: 'success',
          title: i18n.SAME_UPDATE,
          description: i18n.SAME_UPDATE_DESCRIPTION
        };
      case _prebuilt_rule_upgrade.FieldUpgradeStateEnum.NoConflict:
        return {
          color: 'success',
          badge: /*#__PURE__*/_react.default.createElement(_ready_for_upgrade_badge.ReadyForUpgradeBadge, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 41,
              columnNumber: 18
            }
          }),
          title: i18n.NO_CONFLICT,
          description: i18n.NO_CONFLICT_DESCRIPTION
        };
      case _prebuilt_rule_upgrade.FieldUpgradeStateEnum.Accepted:
        return {
          color: 'success',
          badge: /*#__PURE__*/_react.default.createElement(_ready_for_upgrade_badge.ReadyForUpgradeBadge, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 49,
              columnNumber: 18
            }
          }),
          title: i18n.REVIEWED_AND_ACCEPTED
        };
      case _prebuilt_rule_upgrade.FieldUpgradeStateEnum.SolvableConflict:
        return {
          color: 'warning',
          badge: /*#__PURE__*/_react.default.createElement(_review_required_badge.ReviewRequiredBadge, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 56,
              columnNumber: 18
            }
          }),
          title: i18n.SOLVABLE_CONFLICT,
          description: i18n.SOLVABLE_CONFLICT_DESCRIPTION
        };
      case _prebuilt_rule_upgrade.FieldUpgradeStateEnum.NonSolvableConflict:
        return {
          color: 'danger',
          badge: /*#__PURE__*/_react.default.createElement(_action_required.ActionRequiredBadge, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 64,
              columnNumber: 18
            }
          }),
          title: i18n.NON_SOLVABLE_CONFLICT,
          description: i18n.NON_SOLVABLE_CONFLICT_DESCRIPTION
        };
      default:
        return (0, _utility_types.assertUnreachable)(state);
    }
  }, [state]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: color,
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }, badge), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 11
    }
  }, title)), description && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }, i18n.SEPARATOR, " ", description)));
}