"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KqlQueryEditForm = KqlQueryEditForm;
var _react = _interopRequireDefault(require("react"));
var _schema = require("../../../../../../../rule_creation_ui/components/step_define_rule/schema");
var _field_final_side = require("../../../field_final_side");
var _detection_engine = require("../../../../../../../../../common/api/detection_engine");
var _helpers = require("../../../../helpers");
var _kql_query_edit = require("./kql_query_edit");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/three_way_diff/final_edit/fields/kql_query/kql_query_edit_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function KqlQueryEditForm() {
  return /*#__PURE__*/_react.default.createElement(_field_final_side.RuleFieldEditFormWrapper, {
    component: _kql_query_edit.KqlQueryEdit,
    ruleFieldFormSchema: kqlQuerySchema,
    deserializer: kqlQueryDeserializer,
    serializer: kqlQuerySerializer,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  });
}
const kqlQuerySchema = {
  ruleType: _schema.schema.ruleType,
  queryBar: _schema.schema.queryBar
};
function kqlQueryDeserializer(fieldValue, finalDiffableRule) {
  const parsedFieldValue = _detection_engine.RuleKqlQuery.parse(fieldValue.kql_query);
  if (parsedFieldValue.type === _detection_engine.KqlQueryType.inline_query) {
    const returnValue = {
      ruleType: finalDiffableRule.type,
      queryBar: {
        query: {
          query: parsedFieldValue.query,
          language: parsedFieldValue.language
        },
        filters: (0, _helpers.isFilters)(parsedFieldValue.filters) ? parsedFieldValue.filters : [],
        saved_id: null
      }
    };
    return returnValue;
  }
  const returnValue = {
    ruleType: finalDiffableRule.type,
    queryBar: {
      query: {
        query: '',
        language: ''
      },
      filters: [],
      saved_id: parsedFieldValue.saved_query_id
    }
  };
  return returnValue;
}
function kqlQuerySerializer(formData) {
  const formValue = formData;
  if (formValue.ruleType === 'saved_query') {
    const savedQueryId = _detection_engine.SavedQueryId.parse(formValue.queryBar.saved_id);
    const savedKqlQuery = {
      type: _detection_engine.KqlQueryType.saved_query,
      saved_query_id: savedQueryId
    };
    return {
      kql_query: savedKqlQuery
    };
  }
  const query = _detection_engine.RuleQuery.parse(formValue.queryBar.query.query);
  const language = _detection_engine.KqlQueryLanguage.parse(formValue.queryBar.query.language);
  const inlineKqlQuery = {
    type: _detection_engine.KqlQueryType.inline_query,
    query,
    language,
    filters: formValue.queryBar.filters
  };
  return {
    kql_query: inlineKqlQuery
  };
}