"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionsAddToListsOptions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
var _add_to_lists_table = require("../add_to_lists_table");
var _kibana = require("../../../../../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_exceptions/components/flyout_components/add_to_lists_options/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ExceptionsAddToListsOptionsComponent = ({
  rulesCount,
  selectedRadioOption,
  sharedLists,
  onListsSelectionChange,
  onRadioChange
}) => {
  const {
    navigateToApp
  } = (0, _kibana.useKibana)().services.application;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const closePopover = () => setIsPopoverOpen(false);
  const onPopOverButtonClick = () => setIsPopoverOpen(!isPopoverOpen);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, {
    name: "addToListsOption",
    id: "add_to_lists",
    label: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "flexStart",
      gutterSize: "none",
      responsive: false,
      "data-test-subj": "addToListsRadioOptionLabel",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 15
      }
    }, i18n.ADD_TO_LISTS_OPTION)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      "data-test-subj": "addToListsOption",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        iconType: "info",
        onClick: onPopOverButtonClick,
        "aria-label": i18n.ADD_TO_LISTS_OPTION_TOOLTIP_ARIA_LABEL,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 63,
          columnNumber: 19
        }
      }),
      isOpen: isPopoverOpen,
      closePopover: closePopover,
      anchorPosition: "upCenter",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      css: {
        width: '300px'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 19
      }
    }, sharedLists.length === 0 ? i18n.ADD_TO_LISTS_OPTION_DISABLED_TOOLTIP(rulesCount) : i18n.ADD_TO_LISTS_OPTION_TOOLTIP)), /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverFooter, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      iconType: "popout",
      iconSide: "right",
      onClick: () => navigateToApp('security', {
        openInNewTab: true,
        path: '/exceptions'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 19
      }
    }, i18n.GO_TO_EXCEPTIONS))))),
    checked: selectedRadioOption === 'add_to_lists',
    disabled: sharedLists.length === 0 && rulesCount > 0,
    onChange: () => onRadioChange('add_to_lists'),
    "data-test-subj": "addToListsRadioOption",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }), selectedRadioOption === 'add_to_lists' && (sharedLists.length > 0 || rulesCount === 0) && /*#__PURE__*/_react.default.createElement(_add_to_lists_table.ExceptionsAddToListsTable, {
    showAllSharedLists: rulesCount === 0,
    sharedExceptionLists: sharedLists,
    onListSelectionChange: onListsSelectionChange,
    "data-test-subj": "exceptionsAddToListTable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 9
    }
  }));
};
const ExceptionsAddToListsOptions = exports.ExceptionsAddToListsOptions = /*#__PURE__*/_react.default.memo(ExceptionsAddToListsOptionsComponent);
ExceptionsAddToListsOptions.displayName = 'ExceptionsAddToListsOptions';