"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../../utils/translations"));
var _use_disassociate_exception_list = require("../../../rule_management/logic/use_disassociate_exception_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_exceptions/components/error_callout/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ErrorCalloutComponent = ({
  http,
  rule,
  errorInfo,
  onCancel,
  onError,
  onSuccess
}) => {
  const [listToDelete, setListToDelete] = (0, _react.useState)(null);
  const [errorTitle, setErrorTitle] = (0, _react.useState)('');
  const [errorMessage, setErrorMessage] = (0, _react.useState)(i18n.ADD_EXCEPTION_FETCH_ERROR);
  const handleOnSuccess = (0, _react.useCallback)(() => {
    onSuccess(listToDelete != null ? listToDelete.id : '');
  }, [onSuccess, listToDelete]);
  const [isDisassociatingList, handleDisassociateExceptionList] = (0, _use_disassociate_exception_list.useDisassociateExceptionList)({
    http,
    ruleRuleId: rule != null ? rule.rule_id : '',
    onSuccess: handleOnSuccess,
    onError
  });
  const canDisplay404Actions = (0, _react.useMemo)(() => errorInfo.code === 404 && rule != null && listToDelete != null && handleDisassociateExceptionList != null, [errorInfo.code, listToDelete, handleDisassociateExceptionList, rule]);
  (0, _react.useEffect)(() => {
    // Yes, it's redundant, unfortunately typescript wasn't picking up
    // that `listToDelete` is checked in canDisplay404Actions
    if (canDisplay404Actions && listToDelete != null) {
      setErrorMessage(i18n.ADD_EXCEPTION_FETCH_404_ERROR(listToDelete.id));
    }
    setErrorTitle(`${errorInfo.reason}${errorInfo.code != null ? ` (${errorInfo.code})` : ''}`);
  }, [errorInfo.reason, errorInfo.code, listToDelete, canDisplay404Actions]);
  const handleDisassociateList = (0, _react.useCallback)(() => {
    // Yes, it's redundant, unfortunately typescript wasn't picking up
    // that `handleDisassociateExceptionList` and `list` are checked in
    // canDisplay404Actions
    if (canDisplay404Actions && rule != null && listToDelete != null && handleDisassociateExceptionList != null) {
      var _rule$exceptions_list;
      const exceptionLists = ((_rule$exceptions_list = rule.exceptions_list) !== null && _rule$exceptions_list !== void 0 ? _rule$exceptions_list : []).filter(({
        id
      }) => id !== listToDelete.id);
      handleDisassociateExceptionList(exceptionLists);
    }
  }, [handleDisassociateExceptionList, listToDelete, canDisplay404Actions, rule]);
  (0, _react.useEffect)(() => {
    if (errorInfo.code === 404 && rule != null && rule.exceptions_list != null) {
      const [listFound] = rule.exceptions_list.filter(({
        id,
        list_id: listId
      }) => errorInfo.details != null && errorInfo.details.includes(id) || errorInfo.listListId === listId);
      setListToDelete(listFound);
    }
  }, [rule, errorInfo.details, errorInfo.code, errorInfo.listListId]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "errorCalloutContainer",
    title: `${i18n.ERROR}: ${errorTitle}`,
    color: "danger",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "errorCalloutMessage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 9
    }
  }, errorMessage)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }), listToDelete != null && /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "accordion1",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 15
      }
    }, i18n.MODAL_ERROR_ACCORDION_TEXT)),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "json",
    fontSize: "s",
    paddingSize: "m",
    overflowHeight: 300,
    isCopyable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  }, JSON.stringify(listToDelete))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "errorCalloutCancelButton",
    color: "danger",
    isDisabled: isDisassociatingList,
    onClick: onCancel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 7
    }
  }, i18n.CANCEL), canDisplay404Actions && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "errorCalloutDisassociateButton",
    isLoading: isDisassociatingList,
    onClick: handleDisassociateList,
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 9
    }
  }, i18n.CLEAR_EXCEPTIONS_LABEL));
};
ErrorCalloutComponent.displayName = 'ErrorCalloutComponent';
const ErrorCallout = exports.ErrorCallout = /*#__PURE__*/_react.default.memo(ErrorCalloutComponent);
ErrorCallout.displayName = 'ErrorCallout';