"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MachineLearningJobIdEdit = MachineLearningJobIdEdit;
var _react = _interopRequireWildcard(require("react"));
var _shared_imports = require("../../../../shared_imports");
var _ml_job_select = require("../ml_job_select");
var _use_security_jobs = require("../../../../common/components/ml_popover/hooks/use_security_jobs");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation/components/machine_learning_job_id_edit/machine_learning_job_id_edit.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function MachineLearningJobIdEdit({
  path,
  shouldShowHelpText
}) {
  const {
    loading,
    jobs
  } = (0, _use_security_jobs.useSecurityJobs)();
  const componentProps = (0, _react.useMemo)(() => ({
    jobs,
    loading,
    shouldShowHelpText
  }), [jobs, loading, shouldShowHelpText]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: path,
    config: MACHINE_LEARNING_JOB_ID_FIELD_CONFIG,
    component: _ml_job_select.MlJobSelect,
    componentProps: componentProps,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  });
}
const MACHINE_LEARNING_JOB_ID_FIELD_CONFIG = {
  label: i18n.MACHINE_LEARNING_JOB_ID_LABEL,
  validations: [{
    validator: _shared_imports.fieldValidators.emptyField(i18n.MACHINE_LEARNING_JOB_ID_EMPTY_FIELD_VALIDATION_ERROR)
  }]
};