"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuppressionDurationSelector = SuppressionDurationSelector;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _shared_imports = require("../../../../../shared_imports");
var _types = require("../../../../common/types");
var _duration_input = require("../../duration_input");
var _fields = require("../constants/fields");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation/components/alert_suppression_edit/components/suppression_duration_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SuppressionDurationSelector({
  onlyPerTimePeriod,
  onlyPerTimePeriodReasonMessage,
  disabled
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "alertSuppressionDuration",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseMultiFields, {
    fields: {
      suppressionDurationSelector: {
        path: _fields.ALERT_SUPPRESSION_DURATION_TYPE_FIELD_NAME
      },
      suppressionDurationValue: {
        path: `${_fields.ALERT_SUPPRESSION_DURATION_FIELD_NAME}.${_fields.ALERT_SUPPRESSION_DURATION_VALUE_FIELD_NAME}`
      },
      suppressionDurationUnit: {
        path: `${_fields.ALERT_SUPPRESSION_DURATION_FIELD_NAME}.${_fields.ALERT_SUPPRESSION_DURATION_UNIT_FIELD_NAME}`
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }, ({
    suppressionDurationSelector,
    suppressionDurationValue,
    suppressionDurationUnit
  }) => /*#__PURE__*/_react.default.createElement(SuppressionDurationSelectorFields, {
    suppressionDurationSelectorField: suppressionDurationSelector,
    suppressionDurationValueField: suppressionDurationValue,
    suppressionDurationUnitField: suppressionDurationUnit,
    onlyPerTimePeriod: onlyPerTimePeriod,
    onlyPerTimePeriodReasonMessage: onlyPerTimePeriodReasonMessage,
    disabled: disabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  })));
}
const SuppressionDurationSelectorFields = /*#__PURE__*/(0, _react.memo)(function SuppressionDurationSelectorFields({
  suppressionDurationSelectorField,
  suppressionDurationValueField,
  suppressionDurationUnitField,
  onlyPerTimePeriod = false,
  onlyPerTimePeriodReasonMessage,
  disabled
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    value: durationType,
    setValue: setDurationType
  } = suppressionDurationSelectorField;
  (0, _react.useEffect)(() => {
    if (onlyPerTimePeriod && durationType !== _types.AlertSuppressionDurationType.PerTimePeriod) {
      setDurationType(_types.AlertSuppressionDurationType.PerTimePeriod);
    }
  }, [onlyPerTimePeriod, durationType, setDurationType]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    name: "alertSuppressionDurationType",
    disabled: disabled,
    idSelected: suppressionDurationSelectorField.value,
    options: [{
      id: _types.AlertSuppressionDurationType.PerRuleExecution,
      label: onlyPerTimePeriod ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: onlyPerTimePeriodReasonMessage,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 104,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement("span", {
        tabIndex: 0,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 105,
          columnNumber: 17
        }
      }, i18n.ALERT_SUPPRESSION_DURATION_PER_RULE_EXECUTION_OPTION)) : i18n.ALERT_SUPPRESSION_DURATION_PER_RULE_EXECUTION_OPTION,
      disabled: onlyPerTimePeriod ? true : disabled
    }, {
      id: _types.AlertSuppressionDurationType.PerTimePeriod,
      disabled,
      label: i18n.ALERT_SUPPRESSION_DURATION_PER_TIME_PERIOD_OPTION
    }],
    onChange: id => {
      suppressionDurationSelectorField.setValue(id);
    },
    "data-test-subj": "alertSuppressionDurationOptions",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _css.css)`
          padding-left: ${euiTheme.size.l};
        `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_duration_input.DurationInput, {
    durationValueField: suppressionDurationValueField,
    durationUnitField: suppressionDurationUnitField
    // Suppression duration is also disabled suppression by rule execution is selected in radio button
    ,
    isDisabled: disabled || suppressionDurationSelectorField.value !== _types.AlertSuppressionDurationType.PerTimePeriod,
    "aria-label": i18n.ALERT_SUPPRESSION_DURATION_PER_TIME_PERIOD_OPTION,
    minimumValue: 1,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 9
    }
  })));
});