"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSecurityDashboardsTableItems = exports.useSecurityDashboardsTableColumns = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _links = require("../../common/components/links");
var _kibana = require("../../common/lib/kibana");
var _telemetry = require("../../common/lib/telemetry");
var _constants = require("../../../common/constants");
var _link_to = require("../../common/components/link_to");
var _use_fetch_security_dashboards = require("../containers/use_fetch_security_dashboards");
var _empty_value = require("../../common/components/empty_value");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761649402504941465/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/dashboards/hooks/use_security_dashboards_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useSecurityDashboardsTableItems = () => {
  const {
    dashboards,
    isLoading,
    error
  } = (0, _use_fetch_security_dashboards.useFetchSecurityDashboards)();
  const items = (0, _react.useMemo)(() => {
    if (!dashboards) {
      return [];
    }
    return dashboards.map(securityDashboard => {
      var _securityDashboard$at, _securityDashboard$at2, _securityDashboard$at3, _securityDashboard$at4;
      return {
        ...securityDashboard,
        title: (_securityDashboard$at = (_securityDashboard$at2 = securityDashboard.attributes.title) === null || _securityDashboard$at2 === void 0 ? void 0 : _securityDashboard$at2.toString()) !== null && _securityDashboard$at !== void 0 ? _securityDashboard$at : undefined,
        description: (_securityDashboard$at3 = (_securityDashboard$at4 = securityDashboard.attributes.description) === null || _securityDashboard$at4 === void 0 ? void 0 : _securityDashboard$at4.toString()) !== null && _securityDashboard$at3 !== void 0 ? _securityDashboard$at3 : undefined
      };
    });
  }, [dashboards]);
  return {
    items,
    isLoading,
    error
  };
};
exports.useSecurityDashboardsTableItems = useSecurityDashboardsTableItems;
const useSecurityDashboardsTableColumns = () => {
  const {
    savedObjectsTagging
  } = (0, _kibana.useKibana)().services;
  const {
    navigateTo
  } = (0, _kibana.useNavigateTo)();
  const getSecuritySolutionUrl = (0, _link_to.useGetSecuritySolutionUrl)();
  const getNavigationHandler = (0, _react.useCallback)(href => ev => {
    ev.preventDefault();
    (0, _telemetry.track)(_telemetry.METRIC_TYPE.CLICK, _telemetry.TELEMETRY_EVENT.DASHBOARD);
    navigateTo({
      url: href
    });
  }, [navigateTo]);
  const columns = (0, _react.useMemo)(() => [{
    field: 'title',
    name: _i18n.i18n.translate('xpack.securitySolution.dashboards.title', {
      defaultMessage: 'Title'
    }),
    sortable: true,
    render: (title, {
      id
    }) => {
      const href = `${getSecuritySolutionUrl({
        deepLinkId: _constants.SecurityPageName.dashboards,
        path: id
      })}`;
      return href ? /*#__PURE__*/_react.default.createElement(_links.LinkAnchor, {
        href: href,
        onClick: getNavigationHandler(href),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 69,
          columnNumber: 13
        }
      }, title) : title;
    },
    'data-test-subj': 'dashboardTableTitleCell'
  }, {
    field: 'description',
    name: _i18n.i18n.translate('xpack.securitySolution.dashboards.description', {
      defaultMessage: 'Description'
    }),
    sortable: true,
    render: description => description || (0, _empty_value.getEmptyValue)(),
    'data-test-subj': 'dashboardTableDescriptionCell'
  },
  // adds the tags table column based on the saved object items
  ...(savedObjectsTagging ? [savedObjectsTagging.ui.getTableColumnDefinition()] : [])], [savedObjectsTagging, getSecuritySolutionUrl, getNavigationHandler]);
  return columns;
};
exports.useSecurityDashboardsTableColumns = useSecurityDashboardsTableColumns;